/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.plugins.ParameterInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class ConstructorInfoImpl
extends AnnotationHolder
implements ConstructorInfo {
    private static final long serialVersionUID = 3256727273163272758L;
    protected Constructor constructor;
    protected ClassInfo declaringClass;
    protected TypeInfo[] parameterTypes;
    protected ParameterInfo[] parameters;
    protected ClassInfo[] exceptionTypes;
    protected int modifiers;
    protected int hash;

    public ConstructorInfoImpl() {
    }

    public ConstructorInfoImpl(AnnotationValue[] annotationValueArray, TypeInfo[] typeInfoArray, ClassInfo[] classInfoArray, int n, ClassInfo classInfo) {
        super(annotationValueArray);
        if (typeInfoArray == null) {
            this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
            this.parameters = MethodInfo.NO_PARAMS;
        } else {
            this.parameterTypes = typeInfoArray;
            this.parameters = new ParameterInfoImpl[typeInfoArray.length];
            for (int i = 0; i < typeInfoArray.length; ++i) {
                this.parameters[i] = new ParameterInfoImpl(null, null, typeInfoArray[i]);
            }
        }
        this.exceptionTypes = classInfoArray == null ? MethodInfo.NO_EXCEPTIONS : classInfoArray;
        this.modifiers = n;
        this.declaringClass = classInfo;
        this.calculateHash();
    }

    public ConstructorInfoImpl(AnnotationValue[] annotationValueArray, ParameterInfo[] parameterInfoArray, ClassInfo[] classInfoArray, int n, ClassInfo classInfo) {
        super(annotationValueArray);
        if (parameterInfoArray == null || parameterInfoArray.length == 0) {
            this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
            this.parameters = MethodInfo.NO_PARAMS;
        } else {
            this.parameters = parameterInfoArray;
            this.parameterTypes = new TypeInfo[parameterInfoArray.length];
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                this.parameterTypes[i] = parameterInfoArray[i].getParameterType();
            }
        }
        this.exceptionTypes = classInfoArray == null || classInfoArray.length == 0 ? MethodInfo.NO_EXCEPTIONS : classInfoArray;
        this.modifiers = n;
        this.declaringClass = classInfo;
        this.calculateHash();
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public TypeInfo[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ParameterInfo[] getParameters() {
        return this.parameters;
    }

    public ClassInfo[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    protected void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append(Arrays.asList(this.parameterTypes));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ConstructorInfoImpl)) {
            return false;
        }
        ConstructorInfoImpl constructorInfoImpl = (ConstructorInfoImpl)object;
        if (!this.declaringClass.equals(constructorInfoImpl.declaringClass)) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, constructorInfoImpl.parameterTypes);
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int n = this.declaringClass.hashCode();
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                n = 29 * n + this.parameterTypes[i].hashCode();
            }
        }
        this.hash = n;
    }
}

