/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.FormRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.DOMUtils;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CommandLinkRenderer
extends DomBasicRenderer {
    private static final String HIDDEN_FIELD_NAME = "cl";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String commonCommandLinkHiddenFieldName;
        this.validateParameters(facesContext, uiComponent, UICommand.class);
        if (CommandLinkRenderer.isStatic(uiComponent)) {
            return;
        }
        String commandLinkClientId = uiComponent.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String hiddenFieldNameInRequestMap = (String)requestParameterMap.get(commonCommandLinkHiddenFieldName = CommandLinkRenderer.deriveCommonHiddenFieldName(facesContext, (UIComponent)((UICommand)uiComponent)));
        if (hiddenFieldNameInRequestMap == null || hiddenFieldNameInRequestMap.equals("") || !commandLinkClientId.equals(hiddenFieldNameInRequestMap)) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(uiComponent);
        uiComponent.queueEvent((FacesEvent)actionEvent);
    }

    protected static String deriveCommonHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        if (Beans.isDesignTime()) {
            return "";
        }
        UIComponent parentNamingContainer = CommandLinkRenderer.findForm(uiComponent);
        String parentClientId = parentNamingContainer.getClientId(facesContext);
        String hiddenFieldName = parentClientId + ':' + "_id" + HIDDEN_FIELD_NAME;
        return hiddenFieldName;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element root;
        this.validateParameters(facesContext, uiComponent, UICommand.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        boolean disabled = false;
        try {
            disabled = Boolean.valueOf(String.valueOf(uiComponent.getAttributes().get("disabled")));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!domContext.isInitialized()) {
            if (disabled) {
                root = domContext.createElement("span");
            } else {
                root = domContext.createElement("a");
                root.setAttribute("href", "javascript:;");
            }
            domContext.setRootNode(root);
            CommandLinkRenderer.setRootElementId(facesContext, root, uiComponent);
        }
        root = (Element)domContext.getRootNode();
        DOMContext.removeChildren(root);
        this.renderLinkText(uiComponent, domContext, root);
        Map parameterMap = CommandLinkRenderer.getParameterMap(uiComponent);
        this.renderOnClick(facesContext, uiComponent, root, parameterMap);
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, new String[]{"onclick"});
        if (disabled) {
            root.removeAttribute("disabled");
        }
        FormRenderer.addHiddenField(facesContext, CommandLinkRenderer.deriveCommonHiddenFieldName(facesContext, (UIComponent)((UICommand)uiComponent)));
        Iterator parameterKeys = parameterMap.keySet().iterator();
        while (parameterKeys.hasNext()) {
            String nextKey = (String)parameterKeys.next();
            FormRenderer.addHiddenField(facesContext, nextKey);
        }
        domContext.stepInto(uiComponent);
    }

    private void renderLinkText(UIComponent uiComponent, DOMContext domContext, Element root) {
        Object currentValue = ((UICommand)uiComponent).getValue();
        String linkText = null;
        if (currentValue != null) {
            linkText = DOMUtils.escapeAnsi(currentValue.toString());
        }
        if (linkText != null && linkText.length() != 0) {
            Text labelNode = (Text)root.getFirstChild();
            if (labelNode == null) {
                labelNode = domContext.getDocument().createTextNode(linkText);
                root.appendChild(labelNode);
            } else {
                labelNode.setData(linkText);
            }
        }
    }

    protected void renderOnClick(FacesContext facesContext, UIComponent uiComponent, Element root, Map parameters) {
        UIComponent uiForm = CommandLinkRenderer.findForm(uiComponent);
        if (uiForm == null) {
            throw new FacesException("CommandLink must be contained in a form");
        }
        String uiFormClientId = uiForm.getClientId(facesContext);
        Object onClick = uiComponent.getAttributes().get("onclick");
        onClick = onClick != null ? onClick.toString() + ";" + this.getJavaScriptOnClickString(facesContext, uiComponent, uiFormClientId, parameters) : this.getJavaScriptOnClickString(facesContext, uiComponent, uiFormClientId, parameters);
        root.setAttribute("onclick", onClick.toString());
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, UICommand.class);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private String getJavaScriptOnClickString(FacesContext facesContext, UIComponent uiComponent, String formClientId, Map parameters) {
        return CommandLinkRenderer.getJavascriptHiddenFieldSetters(facesContext, (UICommand)uiComponent, formClientId, parameters) + "iceSubmit(" + " document.forms['" + formClientId + "']," + " this,event); " + "return false;";
    }

    protected static String getJavascriptHiddenFieldSetters(FacesContext facesContext, UICommand uiCommand, String formClientId, Map parameters) {
        StringBuffer buffer = new StringBuffer("document.forms['" + formClientId + "']['");
        buffer.append(CommandLinkRenderer.deriveCommonHiddenFieldName(facesContext, (UIComponent)uiCommand));
        buffer.append("'].value='" + uiCommand.getClientId(facesContext) + "';");
        Iterator parameterKeys = parameters.keySet().iterator();
        while (parameterKeys.hasNext()) {
            String nextParamName = (String)parameterKeys.next();
            Object nextParamValue = parameters.get(nextParamName);
            buffer.append("document.forms['" + formClientId + "']['");
            buffer.append(nextParamName);
            buffer.append("'].value='");
            buffer.append(nextParamValue);
            buffer.append("';");
        }
        return buffer.toString();
    }

    public boolean getRendersChildren() {
        return false;
    }
}

