/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.common.standard;

import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.RequestProxy;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.ResponseProxy;
import com.icesoft.faces.webapp.http.common.Server;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressingServer
implements Server {
    private static final Log log = LogFactory.getLog((Class)CompressingServer.class);
    private Server server;

    public CompressingServer(Server server) {
        this.server = server;
    }

    public void service(Request request) throws Exception {
        String acceptEncodingHeader = request.getHeader("Accept-Encoding");
        if (acceptEncodingHeader != null && (acceptEncodingHeader.indexOf("gzip") >= 0 || acceptEncodingHeader.indexOf("compress") >= 0)) {
            this.server.service(new CompressingRequest(request));
        } else {
            this.server.service(request);
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
    }

    private class CompressingResponse
    extends ResponseProxy {
        private GZIPOutputStream output;

        public CompressingResponse(Response response) {
            super(response);
            response.setHeader("Content-Encoding", "gzip");
        }

        public OutputStream writeBody() throws IOException {
            this.output = new GZIPOutputStream(this.response.writeBody());
            return this.output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeBodyFrom(InputStream in) throws IOException {
            try {
                CompressingServer.copy(in, this.writeBody());
            }
            finally {
                in.close();
            }
        }

        public void finishCompression() throws IOException {
            if (this.output != null) {
                this.output.finish();
            }
        }
    }

    private class CompressingRequest
    extends RequestProxy {
        public CompressingRequest(Request request) {
            super(request);
        }

        public void respondWith(final ResponseHandler handler) throws Exception {
            this.request.respondWith(new ResponseHandler(){

                public void respond(Response response) throws Exception {
                    try {
                        CompressingResponse compressingResponse = new CompressingResponse(response);
                        handler.respond(compressingResponse);
                        compressingResponse.finishCompression();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Connection aborted", (Throwable)e);
                    }
                }
            });
        }
    }
}

