/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.LocationDialog;
import de.hunsicker.jalopy.swing.syntax.SyntaxEditorKit;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Level;

final class PreviewFrame
extends JDialog {
    private static final String EXT_JAVA = ".java";
    private static final String EMPTY_STRING = "".intern();
    boolean customFile;
    private AbstractSettingsPage _page;
    private final Action ACTION_FILE_CLOSE = new FileCloseAction();
    private final Action ACTION_FILE_OPEN = new FileOpenAction();
    private JEditorPane _textArea;
    private Jalopy _jalopy = new Jalopy();
    private List _threads = new ArrayList(3);
    private ResourceBundle bundle;
    private Window _dialog;
    private boolean _wasVisible;

    protected PreviewFrame(Dialog owner) {
        super(owner);
        this.initialize();
        this.setTitle(this.bundle.getString("TLE_PREVIEW"));
    }

    protected PreviewFrame(Frame owner) {
        super(owner);
        this.initialize();
        this.setTitle(this.bundle.getString("TLE_PREVIEW"));
    }

    public static PreviewFrame create(Window owner) {
        return PreviewFrame.create(owner, owner);
    }

    public void setCurrentPage(AbstractSettingsPage page) {
        this._page = page;
    }

    public AbstractSettingsPage getCurrentPage() {
        return this._page;
    }

    public synchronized void setText(String text) {
        if (text == null) {
            text = this._textArea.getText();
        }
        List list = this._threads;
        synchronized (list) {
            FormatThread thread;
            if (this._threads.size() > 0) {
                try {
                    thread = (FormatThread)this._threads.remove(0);
                    thread.interrupt();
                    if (thread.isAlive()) {
                        thread.join(50L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                this._jalopy.reset();
            }
            thread = new FormatThread(text);
            this._threads.add(thread);
            thread.start();
        }
    }

    public String getText() {
        return this._textArea.getText();
    }

    public void show() {
        if (!this._wasVisible) {
            Dimension screen = this.getToolkit().getScreenSize();
            int screenWidth = screen.width;
            int screenHeight = screen.height;
            int dialogWidth = this._dialog.getWidth();
            int dialogHeight = this._dialog.getHeight();
            int dialogX = this._dialog.getX();
            int dialogY = this._dialog.getY();
            int frameWidth = 600;
            if (screenWidth > dialogWidth + frameWidth) {
                this._dialog.setLocation((screenWidth - frameWidth - dialogWidth) / 2, dialogY);
                this.setSize(frameWidth, screenHeight - 30);
                this.setLocation(this._dialog.getX() + dialogWidth, 1);
            } else {
                this._dialog.setLocation(1, dialogY);
                this.setSize(screenWidth - dialogWidth - 2, screenHeight - 30);
                this.setLocation(this._dialog.getX() + dialogWidth, 1);
            }
            this._wasVisible = true;
        }
        super.show();
        this._dialog.toFront();
    }

    public void update() {
        this.setText(this._textArea.getText());
    }

    static PreviewFrame create(Window owner, Window target) {
        PreviewFrame frame = null;
        frame = owner instanceof Frame ? new PreviewFrame((Frame)owner) : new PreviewFrame((Dialog)owner);
        frame._dialog = target;
        return frame;
    }

    private void initialize() {
        this.bundle = ResourceBundleFactory.getBundle("de.hunsicker.jalopy.swing.Bundle");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        SwingHelper.setMenuText(fileMenu, this.bundle.getString("MNE_FILE"), true);
        menuBar.add(fileMenu);
        JMenuItem openFileMenuItem = new JMenuItem(this.ACTION_FILE_OPEN);
        SwingHelper.setMenuText(openFileMenuItem, this.bundle.getString("MNE_OPEN"), true);
        fileMenu.add(openFileMenuItem);
        JMenuItem closeFileMenuItem = new JMenuItem(this.ACTION_FILE_CLOSE);
        SwingHelper.setMenuText(closeFileMenuItem, this.bundle.getString("MNE_CLOSE"), true);
        fileMenu.add(closeFileMenuItem);
        this.setJMenuBar(menuBar);
        SyntaxEditorKit kit = new SyntaxEditorKit();
        this._textArea = new JEditorPane();
        this._textArea.setFont(new Font("Monospaced", 0, 12));
        this._textArea.setEditable(false);
        this._textArea.setCaretPosition(0);
        this._textArea.setMargin(new Insets(2, 2, 2, 2));
        this._textArea.setOpaque(true);
        this._textArea.setEditorKit(kit);
        JScrollPane scrollPane = new JScrollPane(this._textArea);
        this.getContentPane().add(scrollPane);
    }

    private class JavaFilter
    extends FileFilter {
        private JavaFilter() {
        }

        public String getDescription() {
            return PreviewFrame.this.bundle.getString("LBL_JAVA_SOURCE_FILES");
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(PreviewFrame.EXT_JAVA);
        }
    }

    private class FormatThread
    extends Thread {
        String text;

        public FormatThread(String text) {
            this.text = text;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Level ioLevel = null;
            Level parserLevel = null;
            Level parserJavadocLevel = null;
            Level printerLevel = null;
            Level printerJavadocLevel = null;
            try {
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ioLevel = Loggers.IO.getLevel();
                parserLevel = Loggers.PARSER.getLevel();
                parserJavadocLevel = Loggers.PARSER_JAVADOC.getLevel();
                printerLevel = Loggers.PRINTER.getLevel();
                printerJavadocLevel = Loggers.PRINTER_JAVADOC.getLevel();
                ((PreviewFrame)PreviewFrame.this)._page.settings.snapshot();
                throw throwable;
            }
            ioLevel = Loggers.IO.getLevel();
            parserLevel = Loggers.PARSER.getLevel();
            parserJavadocLevel = Loggers.PARSER_JAVADOC.getLevel();
            printerLevel = Loggers.PRINTER.getLevel();
            printerJavadocLevel = Loggers.PRINTER_JAVADOC.getLevel();
            ((PreviewFrame)PreviewFrame.this)._page.settings.snapshot();
            try {
                try {
                    PreviewFrame.this._page.updateSettings();
                    Loggers.IO.setLevel(Level.FATAL);
                    Loggers.PARSER.setLevel(Level.FATAL);
                    Loggers.PARSER_JAVADOC.setLevel(Level.FATAL);
                    Loggers.PRINTER.setLevel(Level.FATAL);
                    Loggers.PRINTER_JAVADOC.setLevel(Level.FATAL);
                    if (!PreviewFrame.this.customFile) {
                        if (PreviewFrame.this._page.getCategory().equals("header")) {
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.FOOTER, false);
                        } else if (PreviewFrame.this._page.getCategory().equals("footer")) {
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.HEADER, false);
                        } else {
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.FOOTER, false);
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.HEADER, false);
                            if (PreviewFrame.this._page.getCategory().equals("indentation")) {
                                ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_EXTENDS, true);
                                ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_IMPLEMENTS, true);
                                ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, true);
                                ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF, true);
                                ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_EXPRESSION, true);
                                ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_VALUES, true);
                            }
                        }
                        if (!PreviewFrame.this._page.getCategory().equals("javadoc")) {
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putInt(ConventionKeys.COMMENT_JAVADOC_CLASS_MASK, 0);
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putInt(ConventionKeys.COMMENT_JAVADOC_CTOR_MASK, 0);
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putInt(ConventionKeys.COMMENT_JAVADOC_METHOD_MASK, 0);
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putInt(ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK, 0);
                        }
                        if (!PreviewFrame.this._page.getPreviewFileName().equals("separationcomments")) {
                            ((PreviewFrame)PreviewFrame.this)._page.settings.putBoolean(ConventionKeys.COMMENT_INSERT_SEPARATOR, false);
                        }
                    }
                    PreviewFrame.this._textArea.getDocument().putProperty("tabSize", new Integer(((PreviewFrame)PreviewFrame.this)._page.settings.get(ConventionKeys.INDENT_SIZE, String.valueOf(4))));
                    PreviewFrame.this._jalopy.setForce(true);
                    if (this.text.length() > 0) {
                        PreviewFrame.this._jalopy.setInput(this.text, PreviewFrame.this._page.getCategory() + PreviewFrame.EXT_JAVA);
                        StringBuffer buf = new StringBuffer(this.text.length());
                        PreviewFrame.this._jalopy.setOutput(buf);
                        PreviewFrame.this._jalopy.format();
                        SwingUtilities.invokeLater(new Runnable(this, buf){
                            private final /* synthetic */ StringBuffer val$buf;
                            private final /* synthetic */ FormatThread this$1;
                            {
                                this.this$1 = this$1;
                                this.val$buf = val$buf;
                            }

                            public void run() {
                                int offset = PreviewFrame.access$500(FormatThread.access$700(this.this$1)).getCaretPosition();
                                PreviewFrame.access$500(FormatThread.access$700(this.this$1)).setText(this.val$buf.toString());
                                if (PreviewFrame.access$500(FormatThread.access$700(this.this$1)).getDocument().getLength() > offset) {
                                    PreviewFrame.access$500(FormatThread.access$700(this.this$1)).setCaretPosition(offset);
                                }
                            }
                        });
                    } else {
                        PreviewFrame.this._textArea.setText(this.text);
                    }
                }
                catch (Throwable ignored) {
                    Object var9_12 = null;
                    ((PreviewFrame)PreviewFrame.this)._page.settings.revert();
                    if (PreviewFrame.this._textArea.getText().equals(EMPTY_STRING)) {
                        PreviewFrame.this._textArea.setText(this.text);
                    }
                    PreviewFrame.this._jalopy.reset();
                    Loggers.IO.setLevel(ioLevel);
                    Loggers.PARSER.setLevel(parserLevel);
                    Loggers.PARSER_JAVADOC.setLevel(parserJavadocLevel);
                    Loggers.PRINTER.setLevel(printerLevel);
                    Loggers.PRINTER_JAVADOC.setLevel(printerJavadocLevel);
                    List list2 = PreviewFrame.this._threads;
                    synchronized (list2) {
                        PreviewFrame.this._threads.remove(this);
                        return;
                    }
                }
                Object var9_11 = null;
                ((PreviewFrame)PreviewFrame.this)._page.settings.revert();
                if (PreviewFrame.this._textArea.getText().equals(EMPTY_STRING)) {
                    PreviewFrame.this._textArea.setText(this.text);
                }
                PreviewFrame.this._jalopy.reset();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                ((PreviewFrame)PreviewFrame.this)._page.settings.revert();
                if (PreviewFrame.this._textArea.getText().equals(EMPTY_STRING)) {
                    PreviewFrame.this._textArea.setText(this.text);
                }
                PreviewFrame.this._jalopy.reset();
                Loggers.IO.setLevel(ioLevel);
                Loggers.PARSER.setLevel(parserLevel);
                Loggers.PARSER_JAVADOC.setLevel(parserJavadocLevel);
                Loggers.PRINTER.setLevel(printerLevel);
                Loggers.PRINTER_JAVADOC.setLevel(printerJavadocLevel);
                List list = PreviewFrame.this._threads;
                synchronized (list) {
                    PreviewFrame.this._threads.remove(this);
                    throw throwable;
                }
            }
            Loggers.IO.setLevel(ioLevel);
            Loggers.PARSER.setLevel(parserLevel);
            Loggers.PARSER_JAVADOC.setLevel(parserJavadocLevel);
            Loggers.PRINTER.setLevel(printerLevel);
            Loggers.PRINTER_JAVADOC.setLevel(printerJavadocLevel);
            List list = PreviewFrame.this._threads;
            synchronized (list) {
                PreviewFrame.this._threads.remove(this);
                return;
            }
        }

        static /* synthetic */ PreviewFrame access$700(FormatThread x0) {
            return x0.PreviewFrame.this;
        }
    }

    private final class FileOpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent ev) {
            LocationDialog dialog = LocationDialog.create(PreviewFrame.this, PreviewFrame.this.bundle.getString("TLE_OPEN_JAVA_FILE"), "XXX", EMPTY_STRING);
            dialog.addFilter(new JavaFilter(), true);
            dialog.setVisible(true);
            switch (dialog.getOption()) {
                case 0: {
                    try {
                        String location = (String)dialog.getSelectedLocation();
                        if (location == null || location.trim().length() == 0) {
                            return;
                        }
                        File file = new File(location);
                        String contents = IoHelper.readTextFile(file);
                        PreviewFrame.this.setText(contents);
                        PreviewFrame.this.customFile = true;
                        PreviewFrame.this.ACTION_FILE_CLOSE.setEnabled(true);
                        break;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    private final class FileCloseAction
    extends AbstractAction {
        public FileCloseAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            PreviewFrame.this.customFile = false;
            String filename = PreviewFrame.this.getCurrentPage().getPreviewFileName();
            PreviewFrame.this.setText(PreviewFrame.this.getCurrentPage().getContainer().loadPreview(filename));
            this.setEnabled(false);
        }
    }
}

