/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.odmg;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.Bag;
import cirrus.hibernate.collections.List;
import cirrus.hibernate.collections.Map;
import cirrus.hibernate.collections.Set;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.odmg.Database;
import cirrus.hibernate.odmg.OQLQuery;
import cirrus.hibernate.odmg.Transaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;

public class Implementation
implements org.odmg.Implementation {
    private Database database;
    private final ThreadLocal threadDatabase = new ThreadLocal();
    private static final Implementation INSTANCE = new Implementation();

    public static Implementation getInstance() {
        return INSTANCE;
    }

    public org.odmg.Transaction newTransaction() {
        try {
            return new Transaction(this.database);
        }
        catch (ODMGException ode) {
            throw new ODMGRuntimeException(ode.getMessage());
        }
    }

    public Database currentDatabase() {
        Database db = (Database)this.threadDatabase.get();
        if (db != null) {
            return db;
        }
        return this.database;
    }

    public org.odmg.Transaction currentTransaction() {
        return this.currentDatabase().currentTransaction();
    }

    public synchronized org.odmg.Database newDatabase() {
        Database db = new Database();
        if (this.database == null) {
            this.database = db;
        }
        this.threadDatabase.set(db);
        return db;
    }

    public org.odmg.OQLQuery newOQLQuery() {
        return new OQLQuery(this.currentDatabase());
    }

    public DList newDList() {
        return new List((SessionImplementor)this.currentDatabase().getSession(), new ArrayList());
    }

    public DBag newDBag() {
        return new Bag((SessionImplementor)this.currentDatabase().getSession(), new ArrayList());
    }

    public DSet newDSet() {
        return new Set((SessionImplementor)this.currentDatabase().getSession(), new HashSet());
    }

    public DArray newDArray() {
        return new List((SessionImplementor)this.currentDatabase().getSession(), new ArrayList());
    }

    public DMap newDMap() {
        return new Map((SessionImplementor)this.currentDatabase().getSession(), new HashMap());
    }

    public String getObjectId(Object obj) {
        try {
            return this.database.getSession().getIdentifier(obj).toString();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public org.odmg.Database getDatabase(Object obj) {
        return this.currentDatabase();
    }
}

