/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.protocols.StateTransferRequest;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class STATE_TRANSFER
extends Protocol
implements RequestHandler {
    Address local_addr = null;
    final Vector members = new Vector(11);
    final Message m = null;
    boolean is_server = false;
    byte[] cached_state = null;
    final Object state_xfer_mutex = new Object();
    long timeout_get_appl_state = 5000L;
    long timeout_return_state = 5000L;
    RequestCorrelator corr = null;
    final Vector observers = new Vector(5);
    final HashMap map = new HashMap(7);

    public String getName() {
        return "STATE_TRANSFER";
    }

    public void init() throws Exception {
        this.map.put("state_transfer", Boolean.TRUE);
        this.map.put("protocol_class", this.getClass().getName());
    }

    public void start() throws Exception {
        this.corr = new RequestCorrelator(this.getName(), this, this);
        this.passUp(new Event(56, this.map));
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
            this.corr = null;
        }
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout_get_appl_state");
        if (str != null) {
            this.timeout_get_appl_state = Long.parseLong(str);
            props.remove("timeout_get_appl_state");
        }
        if ((str = props.getProperty("timeout_return_state")) != null) {
            this.timeout_return_state = Long.parseLong(str);
            props.remove("timeout_return_state");
        }
        if (props.size() > 0) {
            this.log.error((Object)("STATE_TRANSFER.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public Vector requiredUpServices() {
        Vector<Integer> ret = new Vector<Integer>(2);
        ret.addElement(new Integer(22));
        ret.addElement(new Integer(23));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 16: {
                this.is_server = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int k = 0; k < new_members.size(); ++k) {
                            this.members.addElement(new_members.elementAt(k));
                        }
                    }
                    break;
                }
            }
        }
        if (this.corr != null) {
            this.corr.receive(evt);
        } else {
            this.passUp(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int k = 0; k < new_members.size(); ++k) {
                            this.members.addElement(new_members.elementAt(k));
                        }
                    }
                    break;
                }
            }
            case 19: {
                byte[] state;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                Address coord = this.determineCoordinator();
                if (coord == null || coord.equals(this.local_addr)) {
                    Vector<Event> event_list = new Vector<Event>(1);
                    event_list.addElement(new Event(20, new StateTransferInfo()));
                    this.passUp(new Event(23, event_list));
                    return;
                }
                try {
                    this.sendMakeCopyMessage();
                    state = this.getStateFromSingle(info.target);
                }
                catch (Throwable t) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"failed sending state request", t);
                    }
                    state = null;
                }
                Vector<Event> event_list = new Vector<Event>(1);
                event_list.addElement(new Event(20, new StateTransferInfo(null, info.state_id, 0L, state)));
                this.passUp(new Event(23, event_list));
                return;
            }
            case 18: {
                Object object = this.state_xfer_mutex;
                synchronized (object) {
                    StateTransferInfo info = (StateTransferInfo)evt.getArg();
                    this.cached_state = info.state;
                    this.state_xfer_mutex.notifyAll();
                }
                return;
            }
        }
        this.passDown(evt);
    }

    public Object handle(Message msg) {
        try {
            StateTransferRequest req = (StateTransferRequest)msg.getObject();
            switch (req.getType()) {
                case 1: {
                    this.makeCopy(req.getArg());
                    return null;
                }
                case 2: {
                    if (this.is_server) {
                        return this.cached_state;
                    }
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"RETURN_STATE: returning nullas I'm not yet an operational state server !");
                    }
                    return null;
                }
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("type " + req.getType() + "is unknown in StateTransferRequest !"));
            }
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception is " + e));
            }
            return null;
        }
    }

    byte[] getStateFromSingle(Address target) throws Throwable {
        Message msg;
        Vector<Address> dests = new Vector<Address>(11);
        StateTransferRequest r = new StateTransferRequest(2, this.local_addr);
        int num_tries = 0;
        try {
            msg = new Message(null, null, Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return null;
        }
        while (this.members.size() > 1 && num_tries++ < 3) {
            Address dest;
            Address address = dest = target != null ? target : this.determineCoordinator();
            if (dest == null) {
                return null;
            }
            msg.setDest(dest);
            dests.removeAllElements();
            dests.addElement(dest);
            GroupRequest req = new GroupRequest(msg, this.corr, dests, 1, this.timeout_return_state, 0);
            req.execute();
            RspList rsp_list = req.getResults();
            for (int i = 0; i < rsp_list.size(); ++i) {
                Rsp rsp = (Rsp)rsp_list.elementAt(i);
                if (!rsp.wasReceived()) continue;
                return (byte[])rsp.getValue();
            }
            Util.sleep(1000L);
        }
        return null;
    }

    void sendMakeCopyMessage() throws Throwable {
        Message msg = new Message();
        StateTransferRequest r = new StateTransferRequest(1, this.local_addr);
        Vector dests = new Vector(11);
        for (int i = 0; i < this.members.size(); ++i) {
            dests.addElement(this.members.elementAt(i));
        }
        if (dests.size() == 0) {
            return;
        }
        try {
            msg.setBuffer(Util.objectToByteBuffer(r));
        }
        catch (Exception e) {
            // empty catch block
        }
        GroupRequest req = new GroupRequest(msg, this.corr, dests, 2, this.timeout_return_state, 0);
        req.execute();
    }

    Address determineCoordinator() {
        Address ret = null;
        if (this.members != null && this.members.size() > 1) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (this.local_addr.equals(this.members.elementAt(i))) continue;
                return (Address)this.members.elementAt(i);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeCopy(Object sender) {
        if (sender.equals(this.local_addr)) {
            this.passUp(new Event(22));
        } else if (this.is_server) {
            Object object = this.state_xfer_mutex;
            synchronized (object) {
                this.cached_state = null;
                StateTransferInfo info = new StateTransferInfo(this.local_addr);
                this.passUp(new Event(17, info));
                if (this.cached_state == null) {
                    try {
                        this.state_xfer_mutex.wait(this.timeout_get_appl_state);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

