/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        BasicDataSource dataSource = new BasicDataSource();
        RefAddr ra = null;
        ra = ref.get("defaultAutoCommit");
        if (ra != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultReadOnly")) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("driverClassName")) != null) {
            dataSource.setDriverClassName(ra.getContent().toString());
        }
        if ((ra = ref.get("maxActive")) != null) {
            dataSource.setMaxActive(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxIdle")) != null) {
            dataSource.setMaxIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxWait")) != null) {
            dataSource.setMaxWait(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("password")) != null) {
            dataSource.setPassword(ra.getContent().toString());
        }
        if ((ra = ref.get("url")) != null) {
            dataSource.setUrl(ra.getContent().toString());
        }
        if ((ra = ref.get("username")) != null) {
            dataSource.setUsername(ra.getContent().toString());
        }
        if ((ra = ref.get("validationQuery")) != null) {
            dataSource.setValidationQuery(ra.getContent().toString());
        }
        if ((ra = ref.get("removeAbandoned")) != null) {
            dataSource.setRemoveAbandoned(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("removeAbandonedTimeout")) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("logAbandoned")) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(ra.getContent().toString()));
        }
        return dataSource;
    }
}

