/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.wsdl.parser;

import java.util.HashMap;
import java.util.Map;
import org.jboss.com.sun.xml.ws.model.Mode;
import org.jboss.com.sun.xml.ws.model.ParameterBinding;
import org.jboss.com.sun.xml.ws.wsdl.parser.Part;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingOperation {
    private String name;
    private Map<String, ParameterBinding> inputParts;
    private Map<String, ParameterBinding> outputParts;
    private Map<String, String> inputMimeTypes;
    private Map<String, String> outputMimeTypes;
    private boolean explicitInputSOAPBodyParts = false;
    private boolean explicitOutputSOAPBodyParts = false;
    private Boolean emptyInputBody;
    private Boolean emptyOutputBody;
    private Map<String, Part> inParts;
    private Map<String, Part> outParts;
    String reqNamespace;
    String respNamespace;

    public BindingOperation(String name) {
        this.name = name;
        this.inputParts = new HashMap<String, ParameterBinding>();
        this.outputParts = new HashMap<String, ParameterBinding>();
        this.inputMimeTypes = new HashMap<String, String>();
        this.outputMimeTypes = new HashMap<String, String>();
        this.inParts = new HashMap<String, Part>();
        this.outParts = new HashMap<String, Part>();
    }

    public String getName() {
        return this.name;
    }

    public Part getPart(String partName, Mode mode) {
        if (mode.equals((Object)Mode.IN)) {
            return this.inParts.get(partName);
        }
        if (mode.equals((Object)Mode.OUT)) {
            return this.outParts.get(partName);
        }
        return null;
    }

    public void addPart(Part part, Mode mode) {
        if (mode.equals((Object)Mode.IN)) {
            this.inParts.put(part.getName(), part);
        } else if (mode.equals((Object)Mode.OUT)) {
            this.outParts.put(part.getName(), part);
        }
    }

    public Map<String, ParameterBinding> getInputParts() {
        return this.inputParts;
    }

    public Map<String, ParameterBinding> getOutputParts() {
        return this.outputParts;
    }

    public Map<String, String> getInputMimeTypes() {
        return this.inputMimeTypes;
    }

    public Map<String, String> getOutputMimeTypes() {
        return this.outputMimeTypes;
    }

    public ParameterBinding getInputBinding(String part) {
        ParameterBinding block;
        if (this.emptyInputBody == null) {
            this.emptyInputBody = this.inputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.inputParts.get(part)) == null) {
            if (this.explicitInputSOAPBodyParts || this.emptyInputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public ParameterBinding getOutputBinding(String part) {
        ParameterBinding block;
        if (this.emptyOutputBody == null) {
            this.emptyOutputBody = this.outputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((block = this.outputParts.get(part)) == null) {
            if (this.explicitOutputSOAPBodyParts || this.emptyOutputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return block;
    }

    public String getMimeTypeForInputPart(String part) {
        return this.inputMimeTypes.get(part);
    }

    public String getMimeTypeForOutputPart(String part) {
        return this.outputMimeTypes.get(part);
    }

    public void setInputExplicitBodyParts(boolean b) {
        this.explicitInputSOAPBodyParts = b;
    }

    public void setOutputExplicitBodyParts(boolean b) {
        this.explicitOutputSOAPBodyParts = b;
    }

    public String getRequestNamespace() {
        return this.reqNamespace;
    }

    public String getResponseNamespace() {
        return this.respNamespace;
    }
}

