/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import com.arjuna.ats.internal.arjuna.utils.SocketProcessId;
import java.io.IOException;
import java.net.ServerSocket;

public class TransactionStatusManager {
    private Listener _listener;
    private static final String _defaultTsmService = "com.arjuna.ats.arjuna.recovery.ActionStatusService";
    private static final int _defaultTsmPort = 0;
    private boolean _finalizeCalled = false;

    public TransactionStatusManager() {
        int port = TransactionStatusManager.getTsmPort();
        this.start(_defaultTsmService, port);
    }

    public TransactionStatusManager(int port) {
        this.start(_defaultTsmService, port);
    }

    public TransactionStatusManager(String serviceName) {
        int port = TransactionStatusManager.getTsmPort();
        this.start(serviceName, port);
    }

    public TransactionStatusManager(String serviceName, int port) {
        this.start(serviceName, port);
    }

    public void addService(Service service, ServerSocket serverSocket) {
        try {
            this._listener = new Listener(serverSocket, service);
            this._listener.setDaemon(true);
            if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_1", new Object[]{service.getClass().getName(), Integer.toString(serverSocket.getLocalPort())});
            }
            this._listener.start();
        }
        catch (IOException ex) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_2");
        }
    }

    public void finalize() {
        if (!this._finalizeCalled) {
            this._finalizeCalled = true;
            this._listener.stopListener();
            TransactionStatusManagerItem.removeThis(Utility.getProcessUid());
        }
    }

    private void start(String serviceName, int port) {
        int localPort = 0;
        try {
            Class<?> serviceClass = Thread.currentThread().getContextClassLoader().loadClass(serviceName);
            Service service = (Service)serviceClass.newInstance();
            ServerSocket socketServer = TransactionStatusManager.getTsmServerSocket(port);
            localPort = socketServer.getLocalPort();
            this.addService(service, socketServer);
            TransactionStatusManagerItem.createAndSave(socketServer.getLocalPort());
            if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                tsLogger.arjLoggerI18N.info("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_3", new Object[]{Integer.toString(localPort), serviceName});
            }
        }
        catch (ClassNotFoundException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_4", new Object[]{serviceName});
            }
        }
        catch (InstantiationException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_5", new Object[]{serviceName});
            }
        }
        catch (IllegalAccessException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_6", new Object[]{serviceName});
            }
        }
        catch (IOException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_7", new Object[]{Integer.toString(localPort)});
            }
            throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_9"));
        }
    }

    private static final ServerSocket getTsmServerSocket(int port) throws IOException {
        ServerSocket socket = SocketProcessId.getSocket();
        return socket == null ? new ServerSocket(port) : socket;
    }

    private static final int getTsmPort() {
        if (SocketProcessId.getSocket() == null) {
            int port;
            block4: {
                port = 0;
                String tsmPortStr = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.transactionStatusManagerPort");
                if (tsmPortStr != null) {
                    try {
                        port = Integer.parseInt(tsmPortStr);
                    }
                    catch (Exception ex) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block4;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusManager_8", new Object[]{ex});
                    }
                }
            }
            return port;
        }
        return SocketProcessId.getSocket().getLocalPort();
    }
}

