/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger((Class)AbstractKernelDeployer.class);
    protected Kernel kernel;
    protected KernelController controller;
    protected ControllerState requiredState;
    protected ControllerMode mode;

    public AbstractKernelDeployer(Kernel kernel) {
        this(kernel, null, null);
    }

    public AbstractKernelDeployer(final Kernel kernel, ControllerState controllerState, ControllerMode controllerMode) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.kernel = kernel;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                AbstractKernelDeployer.this.controller = kernel.getController();
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction);
        this.requiredState = controllerState;
        this.mode = controllerMode;
    }

    public void deploy(KernelDeployment kernelDeployment) throws Throwable {
        if (kernelDeployment.isInstalled()) {
            throw new IllegalArgumentException("Already installed " + kernelDeployment.getName());
        }
        try {
            this.deployBeans(this.controller, kernelDeployment);
            kernelDeployment.setInstalled(true);
        }
        catch (Throwable throwable) {
            this.undeploy(kernelDeployment);
            throw throwable;
        }
    }

    public void change(KernelDeployment kernelDeployment, ControllerState controllerState) throws Throwable {
        if (!kernelDeployment.isInstalled()) {
            throw new IllegalStateException("Not installed " + kernelDeployment.getName());
        }
        this.changeBeans(this.controller, kernelDeployment, controllerState);
    }

    public void undeploy(KernelDeployment kernelDeployment) {
        this.undeployBeans(this.controller, kernelDeployment);
        kernelDeployment.setInstalled(false);
    }

    public void validate() throws Throwable {
        Set set = this.controller.getNotInstalled();
        this.internalValidate(set);
    }

    public void validate(KernelDeployment kernelDeployment) throws Throwable {
        HashSet hashSet = new HashSet(kernelDeployment.getInstalledContexts());
        this.internalValidate(hashSet);
    }

    protected void internalValidate(Set set) throws Throwable {
        if (!set.isEmpty()) {
            Object object;
            Object object2 = set.iterator();
            while (object2.hasNext()) {
                object = (KernelControllerContext)object2.next();
                if (!object.getState().equals((Object)object.getRequiredState())) continue;
                object2.remove();
            }
            if (!set.isEmpty()) {
                KernelControllerContext kernelControllerContext;
                Object object3;
                object2 = new HashSet();
                object = new HashSet();
                JBossStringBuilder jBossStringBuilder = set.iterator();
                while (jBossStringBuilder.hasNext()) {
                    object3 = (KernelControllerContext)jBossStringBuilder.next();
                    if (object3.getState().equals((Object)ControllerState.ERROR)) {
                        ((HashSet)object2).add(object3);
                        continue;
                    }
                    ((HashSet)object).add(object3);
                }
                jBossStringBuilder = new JBossStringBuilder();
                jBossStringBuilder.append("Incompletely deployed:\n");
                if (((HashSet)object2).size() != 0) {
                    jBossStringBuilder.append("\n*** DEPLOYMENTS IN ERROR:\n");
                    object3 = ((HashSet)object2).iterator();
                    while (object3.hasNext()) {
                        kernelControllerContext = (KernelControllerContext)object3.next();
                        jBossStringBuilder.append(kernelControllerContext.getName()).append(" -> ").append(kernelControllerContext.getError().toString()).append('\n');
                    }
                }
                if (((HashSet)object).size() != 0) {
                    jBossStringBuilder.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES:\n");
                    object3 = ((HashSet)object).iterator();
                    while (object3.hasNext()) {
                        kernelControllerContext = (KernelControllerContext)object3.next();
                        jBossStringBuilder.append(kernelControllerContext.getName()).append(" -> ");
                        DependencyInfo dependencyInfo = kernelControllerContext.getDependencyInfo();
                        Set set2 = dependencyInfo.getIDependOn(null);
                        Iterator iterator = set2.iterator();
                        while (iterator.hasNext()) {
                            DependencyItem dependencyItem = (DependencyItem)iterator.next();
                            jBossStringBuilder.append(dependencyItem.getIDependOn()).append('{').append(dependencyItem.getWhenRequired().getStateString());
                            jBossStringBuilder.append(':');
                            ControllerContext controllerContext = this.controller.getContext(dependencyItem.getIDependOn(), null);
                            if (controllerContext == null) {
                                jBossStringBuilder.append("NOT FOUND");
                            } else {
                                jBossStringBuilder.append(controllerContext.getState().getStateString());
                            }
                            jBossStringBuilder.append('}');
                            if (!iterator.hasNext()) continue;
                            jBossStringBuilder.append(", ");
                        }
                        jBossStringBuilder.append('\n');
                    }
                }
                throw new IllegalStateException(jBossStringBuilder.toString());
            }
        }
    }

    protected void deployBeans(KernelController kernelController, KernelDeployment kernelDeployment) throws Throwable {
        List list = kernelDeployment.getBeans();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                BeanMetaData beanMetaData = (BeanMetaData)list.get(i);
                KernelControllerContext kernelControllerContext = this.deployBean(kernelController, kernelDeployment, beanMetaData);
                kernelDeployment.addInstalledContext(kernelControllerContext);
            }
        }
    }

    protected KernelControllerContext deployBean(KernelController kernelController, KernelDeployment kernelDeployment, BeanMetaData beanMetaData) throws Throwable {
        ClassLoaderMetaData classLoaderMetaData;
        ClassLoaderMetaData classLoaderMetaData2;
        AbstractKernelControllerContext abstractKernelControllerContext = new AbstractKernelControllerContext(null, beanMetaData, null);
        if (this.requiredState != null) {
            abstractKernelControllerContext.setRequiredState(this.requiredState);
        }
        if (this.mode != null) {
            abstractKernelControllerContext.setMode(this.mode);
        }
        if ((classLoaderMetaData2 = beanMetaData.getClassLoader()) == null && kernelDeployment != null && (classLoaderMetaData = kernelDeployment.getClassLoader()) != null) {
            beanMetaData.setClassLoader(classLoaderMetaData);
        }
        kernelController.install(abstractKernelControllerContext);
        return abstractKernelControllerContext;
    }

    protected void changeBeans(KernelController kernelController, KernelDeployment kernelDeployment, ControllerState controllerState) throws Throwable {
        List list = kernelDeployment.getInstalledContexts();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                KernelControllerContext kernelControllerContext = (KernelControllerContext)iterator.next();
                this.changeBean(kernelController, kernelControllerContext, controllerState);
            }
        }
    }

    protected void changeBean(KernelController kernelController, KernelControllerContext kernelControllerContext, ControllerState controllerState) throws Throwable {
        if (ControllerMode.MANUAL.equals((Object)kernelControllerContext.getMode()) && !ControllerState.ERROR.equals((Object)kernelControllerContext.getState())) {
            kernelController.change(kernelControllerContext, controllerState);
        }
    }

    protected void undeployBeans(KernelController kernelController, KernelDeployment kernelDeployment) {
        List list = kernelDeployment.getInstalledContexts();
        if (!list.isEmpty()) {
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                KernelControllerContext kernelControllerContext = (KernelControllerContext)listIterator.previous();
                try {
                    this.undeployBean(kernelController, kernelControllerContext);
                    kernelDeployment.removeInstalledContext(kernelControllerContext);
                }
                catch (Throwable throwable) {
                    log.warn((Object)("Ignored error during uninstall of " + kernelControllerContext), throwable);
                }
            }
        }
    }

    protected void undeployBean(KernelController kernelController, KernelControllerContext kernelControllerContext) throws Throwable {
        if (!ControllerState.ERROR.equals((Object)kernelControllerContext.getState())) {
            kernelController.uninstall(kernelControllerContext.getName());
        }
    }
}

