/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.GeneratedAdvisorCallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorConstructionTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorConstructorExecutionTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorFieldAccessTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorMethodExecutionTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformationException;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.util.JavassistToReflect;

public class GeneratedAdvisorInstrumentor
extends Instrumentor {
    private static final String CURRENT_ADVISOR = "currentAdvisor$aop";
    public static final String INSTANCE_ADVISOR = "instanceAdvisor$aop";
    private static final String GET_CURRENT_ADVISOR_NAME = "getCurrentAdvisor$aop";
    public static final String GET_CURRENT_ADVISOR = "getCurrentAdvisor$aop()";
    public static final String ADVISED_CLASS = "advisedClass";
    public static final String DOMAIN = "domain";
    public static final String VERSION = "version";
    public static final String CHECK_VERSION = "checkVersion";
    public static final String ADVICES_UPDATED = "advicesUpdated";
    public static final String INSTANCE_ADVISOR_MIXIN = "instanceAdvisorMixin";
    public static final String CREATE_INSTANCE_ADVISOR = "createInstanceAdvisor";
    public static final String INITIALISE_CALLERS = "initialiseCallers";
    public static final String INITIALISE_FIELD_WRITES = "initialiseFieldWrites";
    public static final String INITIALISE_FIELD_READS = "initialiseFieldReads";
    public static final String INITIALISE_CONSTRUCTIONS = "initialiseConstructions";
    public static final String INITIALISE_CONSTRUCTORS = "initialiseConstructors";
    public static final String INITIALISE_METHODS = "initialiseMethods";
    public static final CtClass[] EMPTY_EXCEPTIONS = new CtClass[0];
    public static final CtClass[] EMPTY_SIG = new CtClass[0];
    CtClass genadvisor;
    CtClass genInstanceAdvisor;

    public GeneratedAdvisorInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        super(pool, manager, joinpointClassifier, observer);
    }

    public GeneratedAdvisorInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        super(manager, joinpointClassifier);
    }

    protected CtClass getGenadvisor() {
        return this.genadvisor;
    }

    protected CtClass getGenInstanceadvisor() {
        return this.genInstanceAdvisor;
    }

    public boolean transform(CtClass clazz, ClassAdvisor advisor) {
        try {
            super.transform(clazz, advisor);
            if (this.genadvisor != null) {
                this.addInstanceAdvisorWrappers(clazz);
                TransformerCommon.compileOrLoadClass(clazz, this.genadvisor);
                TransformerCommon.compileOrLoadClass(clazz, this.genInstanceAdvisor);
            }
            return true;
        }
        catch (Throwable e) {
            if (AspectManager.suppressTransformationErrors) {
                System.err.println("[warn] AOP Instrumentor failed to transform " + clazz.getName());
                e.printStackTrace();
                return false;
            }
            if (e instanceof TransformationException) {
                throw (TransformationException)e;
            }
            e.printStackTrace();
            throw new RuntimeException("failed to transform: " + clazz.getName(), e);
        }
    }

    protected void intitialiseTransformers() {
        this.callerTransformer = new GeneratedAdvisorCallerTransformer(this, this.manager);
        this.fieldAccessTransformer = new GeneratedAdvisorFieldAccessTransformer(this);
        this.constructorExecutionTransformer = new GeneratedAdvisorConstructorExecutionTransformer(this);
        this.constructionTransformer = new GeneratedAdvisorConstructionTransformer(this);
        this.methodExecutionTransformer = new GeneratedAdvisorMethodExecutionTransformer(this);
    }

    protected CtMethod createMixinInvokeMethod(CtClass clazz, CtClass mixinClass, String initializer, CtMethod method, long hash) throws CannotCompileException, NotFoundException, Exception {
        return ((GeneratedAdvisorMethodExecutionTransformer)this.methodExecutionTransformer).addMixinWrappersAndInfo(this, clazz, mixinClass, initializer, this.genadvisor, method);
    }

    protected static String getAdvisorName(CtClass clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(46) + 1) + "Advisor";
    }

    protected static String getInstanceAdvisorName(CtClass clazz) {
        String className = clazz.getName();
        return className.substring(className.lastIndexOf(46) + 1) + "InstanceAdvisor";
    }

    protected static String getAdvisorFQN(CtClass clazz) {
        return clazz.getName() + "$" + GeneratedAdvisorInstrumentor.getAdvisorName(clazz);
    }

    protected static String getInstanceAdvisorFQN(CtClass clazz) {
        return clazz.getName() + "$" + GeneratedAdvisorInstrumentor.getInstanceAdvisorName(clazz);
    }

    protected CtClass createAdvisorClass(CtClass clazz) throws NotFoundException, CannotCompileException {
        String innerClassName = GeneratedAdvisorInstrumentor.getAdvisorName(clazz);
        boolean classStatic = true;
        this.genadvisor = clazz.makeNestedClass(innerClassName, true);
        this.genadvisor.setModifiers(Modifier.setProtected((int)this.genadvisor.getModifiers()));
        CtClass superAdvisor = this.getSuperClassAdvisor(clazz.getSuperclass());
        if (superAdvisor == null) {
            this.genadvisor.setSuperclass(this.forName(GeneratedClassAdvisor.class.getName()));
        } else {
            this.genadvisor.setSuperclass(superAdvisor);
        }
        CtClass untransformable = this.getClassPool().get("org.jboss.aop.instrument.Untransformable");
        this.genadvisor.addInterface(untransformable);
        CtField version = new CtField(CtClass.intType, VERSION, this.genadvisor);
        this.genadvisor.addField(version);
        CtField domain = new CtField(this.forName("org.jboss.aop.Domain"), DOMAIN, this.genadvisor);
        domain.setModifiers(4);
        this.genadvisor.addField(domain);
        CtMethod getter = CtNewMethod.getter((String)"getDomain", (CtField)domain);
        this.genadvisor.addMethod(getter);
        if (this.isBaseClass(clazz)) {
            CtMethod rebuildInterceptors = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)"rebuildInterceptors", (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, (String)"{version++;super.rebuildInterceptors();}", (CtClass)this.genadvisor);
            this.genadvisor.addMethod(rebuildInterceptors);
            CtMethod internalRebuildInterceptors = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)"internalRebuildInterceptors", (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, (String)"{super.rebuildInterceptors();}", (CtClass)this.genadvisor);
            this.genadvisor.addMethod(internalRebuildInterceptors);
        }
        CtMethod initialiseMethods = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)INITIALISE_METHODS, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, (String)(this.isBaseClass(clazz) ? null : "{super.initialiseMethods();}"), (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialiseMethods);
        CtMethod initialiseConstructors = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)INITIALISE_CONSTRUCTORS, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, null, (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialiseConstructors);
        CtMethod initialiseConstructions = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)INITIALISE_CONSTRUCTIONS, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, (String)(this.isBaseClass(clazz) ? null : "{super.initialiseConstructions();}"), (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialiseConstructions);
        CtMethod initialiseFieldReads = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)INITIALISE_FIELD_READS, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, (String)(this.isBaseClass(clazz) ? null : "{super.initialiseFieldReads();}"), (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialiseFieldReads);
        CtMethod initialiseFieldWrites = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)INITIALISE_FIELD_WRITES, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, (String)(this.isBaseClass(clazz) ? null : "{super.initialiseFieldWrites();}"), (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialiseFieldWrites);
        CtMethod initialiseCallers = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)INITIALISE_CALLERS, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, null, (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialiseCallers);
        CtField advisedClass = new CtField(this.forName(Class.class.getName()), ADVISED_CLASS, this.genadvisor);
        advisedClass.setModifiers(12);
        this.genadvisor.addField(advisedClass, CtField.Initializer.byExpr((String)JavassistToReflect.getClassObjectString(clazz)));
        this.createAdvisorCtors(clazz);
        return this.genadvisor;
    }

    protected CtClass createInstanceAdvisorClass(CtClass clazz) throws NotFoundException, CannotCompileException {
        String innerClassName = GeneratedAdvisorInstrumentor.getInstanceAdvisorName(clazz);
        boolean classStatic = true;
        this.genInstanceAdvisor = clazz.makeNestedClass(innerClassName, true);
        this.genInstanceAdvisor.setModifiers(Modifier.setProtected((int)this.genInstanceAdvisor.getModifiers()));
        CtClass superAdvisor = this.getSuperClassAdvisor(clazz.getSuperclass());
        this.genInstanceAdvisor.setSuperclass(this.getGenadvisor());
        CtClass untransformable = this.getClassPool().get("org.jboss.aop.instrument.Untransformable");
        this.genInstanceAdvisor.addInterface(untransformable);
        CtField classAdvisor = new CtField(this.genadvisor, "classAdvisor", this.genInstanceAdvisor);
        this.genInstanceAdvisor.addField(classAdvisor);
        CtMethod advicesUpdated = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)ADVICES_UPDATED, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, null, (CtClass)this.genInstanceAdvisor);
        this.genInstanceAdvisor.addMethod(advicesUpdated);
        this.implementInstanceAdvisorMethods();
        CtMethod checkVersion = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)CHECK_VERSION, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, null, (CtClass)this.genInstanceAdvisor);
        String cvBody = "{   if (classAdvisor.version != super.version)    {       super.version = classAdvisor.version;      internalRebuildInterceptors();       if (instanceAdvisorMixin.hasInterceptors())      {          advicesUpdated();      }   } }";
        checkVersion.setBody(cvBody);
        this.genInstanceAdvisor.addMethod(checkVersion);
        CtConstructor ctor = CtNewConstructor.make((CtClass[])new CtClass[]{this.forName("java.lang.Object"), this.genadvisor}, (CtClass[])new CtClass[0], (CtClass)this.genInstanceAdvisor);
        String body = "{    super($2);   instanceAdvisorMixin = new org.jboss.aop.GeneratedInstanceAdvisorMixin($1, $2);   this.classAdvisor = $2;   super.version = classAdvisor.version;}";
        ctor.setBody(body);
        this.genInstanceAdvisor.addConstructor(ctor);
        return this.genInstanceAdvisor;
    }

    protected void createAdvisorCtors(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtMethod initialise = CtNewMethod.make((int)4, (CtClass)CtClass.voidType, (String)"initialise", (CtClass[])new CtClass[]{this.forName("org.jboss.aop.AspectManager")}, (CtClass[])EMPTY_EXCEPTIONS, null, (CtClass)this.genadvisor);
        this.genadvisor.addMethod(initialise);
        initialise.setBody("{   domain= new org.jboss.aop.GeneratedAdvisorDomain($1, advisedClass, false);    ((org.jboss.aop.Domain)domain).setInheritsBindings(true);    initialiseMethods();   initialiseConstructors();   initialiseConstructions();   initialiseFieldReads();   initialiseFieldWrites();   super.initialise(advisedClass, domain);   initialiseCallers();}");
        CtConstructor ctor = CtNewConstructor.defaultConstructor((CtClass)this.genadvisor);
        ctor.setBody("{   super(\"" + clazz.getName() + "\"); " + "   initialise(org.jboss.aop.AspectManager.instance());" + "}");
        this.genadvisor.addConstructor(ctor);
        CtConstructor ctorWithParentAdvisor = CtNewConstructor.make((CtClass[])new CtClass[]{this.genadvisor}, (CtClass[])EMPTY_EXCEPTIONS, (CtClass)this.genadvisor);
        ctorWithParentAdvisor.setBody("{   super(\"" + clazz.getName() + "\"); " + "   super.setParentAdvisor($1);" + "   initialise($1.getDomain());" + "}");
        this.genadvisor.addConstructor(ctorWithParentAdvisor);
        CtConstructor ctorForSubAdvisors = CtNewConstructor.make((CtClass[])new CtClass[]{this.forName("java.lang.String")}, (CtClass[])new CtClass[0], (CtClass)this.genadvisor);
        this.genadvisor.addConstructor(ctorForSubAdvisors);
        ctorForSubAdvisors.setBody("{super($1);}");
        ctorForSubAdvisors.setModifiers(4);
    }

    protected CtClass getSuperClassAdvisor(CtClass superclass) throws NotFoundException {
        if (superclass != null) {
            try {
                if (this.isAdvised(superclass)) {
                    return this.forName(GeneratedAdvisorInstrumentor.getAdvisorFQN(superclass));
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            return this.getSuperClassAdvisor(superclass.getSuperclass());
        }
        return null;
    }

    protected void implementInstanceAdvisorMethods() throws NotFoundException, CannotCompileException {
        CtClass instanceAdvisor = this.getClassPool().get("org.jboss.aop.InstanceAdvisor");
        this.genInstanceAdvisor.addInterface(instanceAdvisor);
        CtField instanceAdvisorMixin = new CtField(this.getClassPool().get("org.jboss.aop.GeneratedInstanceAdvisorMixin"), INSTANCE_ADVISOR_MIXIN, this.genInstanceAdvisor);
        this.genInstanceAdvisor.addField(instanceAdvisorMixin);
        CtMethod[] instanceAdvisorMethods = instanceAdvisor.getDeclaredMethods();
        for (int i = 0; i < instanceAdvisorMethods.length; ++i) {
            String name = instanceAdvisorMethods[i].getName();
            if (name.equals("hasAspects") || name.equals("getDomain")) continue;
            String ret = instanceAdvisorMethods[i].getReturnType().equals(CtClass.voidType) ? "" : "return ";
            StringBuffer delegatingBody = new StringBuffer();
            delegatingBody.append("{");
            if (name.startsWith("insertInterceptor") || name.startsWith("removeInterceptor") || name.startsWith("appendInterceptor")) {
                delegatingBody.append("advicesUpdated();");
            }
            if (!instanceAdvisorMethods[i].getReturnType().equals(CtClass.voidType)) {
                delegatingBody.append("return ");
            }
            delegatingBody.append("instanceAdvisorMixin." + instanceAdvisorMethods[i].getName() + "($$);}");
            CtMethod m = CtNewMethod.make((int)1, (CtClass)instanceAdvisorMethods[i].getReturnType(), (String)instanceAdvisorMethods[i].getName(), (CtClass[])instanceAdvisorMethods[i].getParameterTypes(), (CtClass[])instanceAdvisorMethods[i].getExceptionTypes(), (String)delegatingBody.toString(), (CtClass)this.genInstanceAdvisor);
            this.genInstanceAdvisor.addMethod(m);
        }
    }

    private void addCreateInstanceAdvisorToGenAdvisor(CtClass clazz) throws NotFoundException, CannotCompileException {
        CtMethod createInstanceAdvisor = CtNewMethod.make((int)1, (CtClass)this.forName("org.jboss.aop.Advisor"), (String)CREATE_INSTANCE_ADVISOR, (CtClass[])new CtClass[]{this.forName("java.lang.Object")}, (CtClass[])EMPTY_EXCEPTIONS, (String)("{return new " + GeneratedAdvisorInstrumentor.getInstanceAdvisorFQN(clazz) + "($1, this);}"), (CtClass)this.genadvisor);
        this.genadvisor.addMethod(createInstanceAdvisor);
    }

    protected void doSetupBasics(CtClass clazz) throws CannotCompileException, NotFoundException {
        this.createAdvisorClass(clazz);
        this.createInstanceAdvisorClass(clazz);
        this.addCreateInstanceAdvisorToGenAdvisor(clazz);
        this.createAdvisorFieldsAndGetter(clazz);
    }

    private void createAdvisorFieldsAndGetter(CtClass clazz) throws NotFoundException, CannotCompileException {
        CtField classAdvisor = new CtField(this.forName("org.jboss.aop.Advisor"), "aop$classAdvisor$aop", clazz);
        classAdvisor.setModifiers(154);
        clazz.addField(classAdvisor, CtField.Initializer.byExpr((String)("new " + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + "()")));
        CtMethod getAdvisor = CtNewMethod.getter((String)"_getAdvisor", (CtField)classAdvisor);
        getAdvisor.setModifiers(1);
        clazz.addMethod(getAdvisor);
        CtMethod getClassAdvisor = CtNewMethod.getter((String)"_getClassAdvisor", (CtField)classAdvisor);
        getClassAdvisor.setModifiers(9);
        clazz.addMethod(getClassAdvisor);
        if (this.isBaseClass(clazz)) {
            CtField currentAdvisor = new CtField(this.forName("org.jboss.aop.Advisor"), CURRENT_ADVISOR, clazz);
            currentAdvisor.setModifiers(196);
            clazz.addField(currentAdvisor, CtField.Initializer.byExpr((String)"_getAdvisor()"));
            CtMethod getCurrentAdvisor = CtNewMethod.make((int)4, (CtClass)this.forName("org.jboss.aop.Advisor"), (String)GET_CURRENT_ADVISOR_NAME, (CtClass[])EMPTY_SIG, (CtClass[])EMPTY_EXCEPTIONS, null, (CtClass)clazz);
            String body = "{   if (currentAdvisor$aop == null)   {      currentAdvisor$aop = _getAdvisor();   }   return currentAdvisor$aop;}";
            getCurrentAdvisor.setBody(body);
            clazz.addMethod(getCurrentAdvisor);
            CtField instanceAdvisor = new CtField(this.forName("org.jboss.aop.InstanceAdvisor"), INSTANCE_ADVISOR, clazz);
            instanceAdvisor.setModifiers(132);
            clazz.addField(instanceAdvisor);
        }
        CtMethod getInstanceAdvisor = CtNewMethod.make((CtClass)this.forName("org.jboss.aop.InstanceAdvisor"), (String)"_getInstanceAdvisor", (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)"{return null;}", (CtClass)clazz);
        String body = "{    if (instanceAdvisor$aop == null)    {       synchronized(this)       {          if (instanceAdvisor$aop == null)          {             org.jboss.aop.Advisor advisor = ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(clazz) + ")" + "aop$classAdvisor$aop" + ").createInstanceAdvisor(this); " + "            " + CURRENT_ADVISOR + " = advisor; " + "            " + INSTANCE_ADVISOR + " = (org.jboss.aop.InstanceAdvisor)advisor; " + "         } " + "      } " + "   } " + "   return " + INSTANCE_ADVISOR + ";" + "}";
        getInstanceAdvisor.setBody(body);
        clazz.addMethod(getInstanceAdvisor);
    }

    public static String updatedAdvicesName(String infoName) {
        return infoName + "_updated";
    }

    private void addInstanceAdvisorWrappers(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtClass superClass = clazz;
        CtClass superAdvisor = this.genadvisor;
        boolean isSuper = false;
        StringBuffer advicesUpdatedCode = new StringBuffer();
        while (true) {
            CtField[] fields = superAdvisor.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                GeneratedAdvisorNameExtractor names;
                if (Modifier.isStatic((int)fields[i].getModifiers()) || (names = GeneratedAdvisorNameExtractor.extractNames(superAdvisor, fields[i])) == null) continue;
                String infoName = fields[i].getName();
                String updatedJoinpointAdvicesName = this.addAdvicesUpdatedForJoinpointField(infoName);
                advicesUpdatedCode.append(updatedJoinpointAdvicesName + " = true;");
                this.addWrapperDelegatorMethodToInstanceAdvisor(names, updatedJoinpointAdvicesName);
            }
            if (this.isBaseClass(superClass)) break;
            isSuper = true;
            superClass = superClass.getSuperclass();
            superAdvisor = superAdvisor.getSuperclass();
        }
        CtMethod advicesUpdated = this.genInstanceAdvisor.getDeclaredMethod(ADVICES_UPDATED);
        advicesUpdated.insertAfter(advicesUpdatedCode.toString());
    }

    private String addAdvicesUpdatedForJoinpointField(String infoName) throws NotFoundException, CannotCompileException {
        String updatedAdvicesName = GeneratedAdvisorInstrumentor.updatedAdvicesName(infoName);
        try {
            this.genInstanceAdvisor.getDeclaredField(updatedAdvicesName);
        }
        catch (NotFoundException e) {
            CtField updatedAdvice = new CtField(CtClass.booleanType, updatedAdvicesName, this.genInstanceAdvisor);
            updatedAdvice.setModifiers(4);
            this.genInstanceAdvisor.addField(updatedAdvice);
        }
        return updatedAdvicesName;
    }

    private void addWrapperDelegatorMethodToInstanceAdvisor(GeneratedAdvisorNameExtractor names, String updatedAdvicesFieldName) throws NotFoundException, CannotCompileException {
        try {
            this.genInstanceAdvisor.getDeclaredMethod(names.getWrapper().getName());
        }
        catch (NotFoundException e) {
            CtMethod instanceAdvisorMethod = CtNewMethod.delegator((CtMethod)names.getWrapper(), (CtClass)this.genInstanceAdvisor);
            String code = "checkVersion();if (" + updatedAdvicesFieldName + ")" + "{ " + "   " + JoinPointInfo.class.getName() + " copy = " + names.getInfoFieldName() + ".copy();" + "   copy.setFactories( " + INSTANCE_ADVISOR_MIXIN + ".getWrappers(copy.getFactories()) );" + "   " + updatedAdvicesFieldName + " = false;" + "   " + names.getJoinPointField().getName() + " = null;" + "   if (" + names.getGeneratorField().getName() + " == null)" + "   {" + "      " + names.getGeneratorField().getName() + " = super.getJoinPointGenerator(" + names.getInfoFieldName() + ");" + "   }" + "   " + names.getGeneratorField().getName() + ".rebindJoinpoint(copy);" + "}";
            instanceAdvisorMethod.insertBefore(code);
            this.genInstanceAdvisor.addMethod(instanceAdvisorMethod);
        }
    }

    protected void initaliseMethodInfo(String infoName, long hash, long unadvisedHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.MethodInfo" + "(" + ADVISED_CLASS + ", " + hash + "L, " + unadvisedHash + "L, this);" + "addMethodInfo" + "(" + infoName + ");";
        this.addCodeToInitialiseMethod(code, INITIALISE_METHODS);
    }

    protected void initialiseFieldReadInfoField(String infoName, int index, String fieldName, long wrapperHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.FieldInfo" + "(" + ADVISED_CLASS + ", " + index + ", " + "\"" + fieldName + "\", " + wrapperHash + "L, this, true);" + "addFieldReadInfo" + "(" + infoName + ");";
        this.addCodeToInitialiseMethod(code, INITIALISE_FIELD_READS);
    }

    protected void initialiseFieldWriteInfoField(String infoName, int index, String fieldName, long wrapperHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.FieldInfo" + "(" + ADVISED_CLASS + ", " + index + ", " + "\"" + fieldName + "\", " + wrapperHash + "L, this, false);" + "addFieldWriteInfo" + "(" + infoName + ");";
        this.addCodeToInitialiseMethod(code, INITIALISE_FIELD_WRITES);
    }

    protected void initialiseConstructorInfoField(String infoName, int index, long constructorHash, long wrapperHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.ConstructorInfo" + "(" + ADVISED_CLASS + ", " + index + ", " + wrapperHash + "L, " + constructorHash + "L, this);" + "addConstructorInfo" + "(" + infoName + ");";
        this.addCodeToInitialiseMethod(code, INITIALISE_CONSTRUCTORS);
    }

    protected void initialiseConstructionInfoField(String infoName, int index, long constructorHash) throws NotFoundException {
        String code = infoName + " = new " + "org.jboss.aop.ConstructionInfo" + "(" + ADVISED_CLASS + ", " + index + ", " + constructorHash + "L, this);" + "addConstructionInfo" + "(" + infoName + ");";
        this.addCodeToInitialiseMethod(code, INITIALISE_CONSTRUCTIONS);
    }

    protected void initialiseCallerInfoField(String infoName, String init) throws CannotCompileException, NotFoundException {
        this.addCodeToInitialiseMethod(infoName + " = " + init + ";", INITIALISE_CALLERS);
    }

    private void addCodeToInitialiseMethod(String code, String methodName) throws NotFoundException {
        CtMethod method = this.genadvisor.getDeclaredMethod(methodName);
        try {
            method.insertAfter(code);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("code was: " + code + " for method " + method.getName());
        }
    }

    protected void addJoinPointGeneratorFieldToGenAdvisor(String name) throws CannotCompileException, NotFoundException {
        CtField field = new CtField(this.forName(JoinPointGenerator.class.getName()), name, this.genadvisor);
        this.genadvisor.addField(field);
    }

    private static class GeneratedAdvisorNameExtractor {
        String infoName;
        CtMethod wrapper;
        CtField joinPointField;
        CtField generatorField;

        private GeneratedAdvisorNameExtractor(String infoName, CtMethod wrapper, CtField joinPointField, CtField generatorField) {
            this.infoName = infoName;
            this.wrapper = wrapper;
            this.joinPointField = joinPointField;
            this.generatorField = generatorField;
        }

        private static GeneratedAdvisorNameExtractor extractNames(CtClass genadvisor, CtField infoField) throws NotFoundException {
            String infoName = infoField.getName();
            if (infoField.getType().getName().equals(FieldInfo.class.getName())) {
                boolean isWrite = infoName.startsWith("aop$FieldInfo_w_");
                if (!isWrite && !infoName.startsWith("aop$FieldInfo_r_")) {
                    throw new RuntimeException("Bad FieldInfo name: '" + infoName + "'");
                }
                String fieldName = infoName.substring("aop$FieldInfo_w_".length());
                String wrapperName = isWrite ? GeneratedAdvisorFieldAccessTransformer.advisorFieldWrite(genadvisor, fieldName) : GeneratedAdvisorFieldAccessTransformer.advisorFieldRead(genadvisor, fieldName);
                CtMethod wrapper = genadvisor.getDeclaredMethod(wrapperName);
                String joinPointName = isWrite ? "joinpoint_w_" + fieldName : "joinpoint_r_" + fieldName;
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                String generatorName = isWrite ? "generator_w_" + fieldName : "generator_r_" + fieldName;
                CtField generatorField = genadvisor.getDeclaredField(generatorName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField, generatorField);
            }
            if (infoField.getType().getName().equals(MethodInfo.class.getName())) {
                if (!infoName.startsWith("aop$MethodInfo_")) {
                    throw new RuntimeException("Bad MethodInfo name: '" + infoName + "'");
                }
                String methodNameHash = infoName.substring("aop$MethodInfo_".length());
                CtMethod wrapper = genadvisor.getDeclaredMethod(methodNameHash);
                String joinPointName = "joinpoint_" + methodNameHash;
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                String generatorName = "generator_" + methodNameHash;
                CtField generatorField = genadvisor.getDeclaredField(generatorName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField, generatorField);
            }
            if (infoField.getType().getName().equals(ConByMethodInfo.class.getName())) {
                if (!infoName.startsWith("aop$constructorCall_")) {
                    throw new RuntimeException("Bad ConByMethodInfo name: '" + infoName + "'");
                }
                CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
                String joinPointName = "joinpoint_CByM_" + infoName.substring("aop$constructorCall_".length());
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                String generatorName = "generator_CByM_" + infoName.substring("aop$constructorCall_".length());
                CtField generatorField = genadvisor.getDeclaredField(generatorName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField, generatorField);
            }
            if (infoField.getType().getName().equals(MethodByMethodInfo.class.getName())) {
                if (!infoName.startsWith("aop$methodCall_")) {
                    throw new RuntimeException("Bad MethodByMethodInfo name: '" + infoName + "'");
                }
                CtMethod wrapper = genadvisor.getDeclaredMethod(infoName);
                String joinPointName = "joinpoint_MByM_" + infoName.substring("aop$methodCall_".length());
                CtField joinPointField = genadvisor.getDeclaredField(joinPointName);
                String generatorName = "generator_MByM_" + infoName.substring("aop$methodCall_".length());
                CtField generatorField = genadvisor.getDeclaredField(generatorName);
                return new GeneratedAdvisorNameExtractor(infoName, wrapper, joinPointField, generatorField);
            }
            return null;
        }

        public CtField getJoinPointField() {
            return this.joinPointField;
        }

        public CtField getGeneratorField() {
            return this.generatorField;
        }

        public CtMethod getWrapper() {
            return this.wrapper;
        }

        public String getInfoFieldName() {
            return this.infoName;
        }
    }
}

