/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.util.Enumeration;
import java.util.Hashtable;
import org.javacc.jjtree.ASTBNFDeclaration;
import org.javacc.jjtree.ASTBNFNodeScope;
import org.javacc.jjtree.ASTBNFNonTerminal;
import org.javacc.jjtree.ASTExpansionNodeScope;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.ASTProduction;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.SimpleNode;
import org.javacc.jjtree.Token;
import org.javacc.jjtree.TokenUtils;
import org.javacc.parser.Options;

public class NodeScope {
    private ASTProduction production;
    private ASTNodeDescriptor node_descriptor;
    private String closedVar;
    private String exceptionVar;
    private String nodeVar;
    private int scopeNumber;

    NodeScope(ASTProduction aSTProduction, ASTNodeDescriptor aSTNodeDescriptor) {
        this.production = aSTProduction;
        if (aSTNodeDescriptor == null) {
            String string = this.production.name;
            if (Options.B("NODE_DEFAULT_VOID")) {
                string = "void";
            }
            this.node_descriptor = ASTNodeDescriptor.indefinite(string);
        } else {
            this.node_descriptor = aSTNodeDescriptor;
        }
        this.scopeNumber = this.production.getNodeScopeNumber(this);
        this.nodeVar = this.constructVariable("n");
        this.closedVar = this.constructVariable("c");
        this.exceptionVar = this.constructVariable("e");
    }

    boolean isVoid() {
        return this.node_descriptor.isVoid();
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.nodeVar;
    }

    private String constructVariable(String string) {
        String string2 = "000" + this.scopeNumber;
        return "jjt" + string + string2.substring(string2.length() - 3, string2.length());
    }

    boolean usesCloseNodeVar() {
        return true;
    }

    void insertOpenNodeDeclaration(IO iO, String string) {
        this.insertOpenNodeCode(iO, string);
    }

    void insertOpenNodeCode(IO iO, String string) {
        String string2 = this.node_descriptor.getNodeType();
        NodeFiles.ensure(iO, string2);
        iO.print(string + string2 + " " + this.nodeVar + " = ");
        if (Options.B("NODE_FACTORY")) {
            if (Options.B("NODE_USES_PARSER")) {
                String string3 = Options.B("STATIC") ? "null" : "this";
                iO.println("(" + string2 + ")" + string2 + ".jjtCreate(" + string3 + ", " + this.node_descriptor.getNodeId() + ");");
            } else {
                iO.println("(" + string2 + ")" + string2 + ".jjtCreate(" + this.node_descriptor.getNodeId() + ");");
            }
        } else if (Options.B("NODE_USES_PARSER")) {
            String string4 = Options.B("STATIC") ? "null" : "this";
            iO.println("new " + string2 + "(" + string4 + ", " + this.node_descriptor.getNodeId() + ");");
        } else {
            iO.println("new " + string2 + "(" + this.node_descriptor.getNodeId() + ");");
        }
        if (this.usesCloseNodeVar()) {
            iO.println(string + "boolean " + this.closedVar + " = true;");
        }
        iO.println(string + this.node_descriptor.openNode(this.nodeVar));
        if (Options.B("NODE_SCOPE_HOOK")) {
            iO.println(string + "jjtreeOpenNodeScope(" + this.nodeVar + ");");
        }
    }

    void insertCloseNodeCode(IO iO, String string, boolean bl) {
        iO.println(string + this.node_descriptor.closeNode(this.nodeVar));
        if (this.usesCloseNodeVar() && !bl) {
            iO.println(string + this.closedVar + " = false;");
        }
        if (Options.B("NODE_SCOPE_HOOK")) {
            iO.println(string + "jjtreeCloseNodeScope(" + this.nodeVar + ");");
        }
    }

    void insertOpenNodeAction(IO iO, String string) {
        iO.println(string + "{");
        this.insertOpenNodeCode(iO, string + "  ");
        iO.println(string + "}");
    }

    void insertCloseNodeAction(IO iO, String string) {
        iO.println(string + "{");
        this.insertCloseNodeCode(iO, string + "  ", false);
        iO.println(string + "}");
    }

    private void insertCatchBlocks(IO iO, Enumeration enumeration, String string) {
        if (enumeration.hasMoreElements()) {
            iO.println(string + "} catch (Throwable " + this.exceptionVar + ") {");
            if (this.usesCloseNodeVar()) {
                iO.println(string + "  if (" + this.closedVar + ") {");
                iO.println(string + "    jjtree.clearNodeScope(" + this.nodeVar + ");");
                iO.println(string + "    " + this.closedVar + " = false;");
                iO.println(string + "  } else {");
                iO.println(string + "    jjtree.popNode();");
                iO.println(string + "  }");
            }
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                iO.println(string + "  if (" + this.exceptionVar + " instanceof " + string2 + ") {");
                iO.println(string + "    throw (" + string2 + ")" + this.exceptionVar + ";");
                iO.println(string + "  }");
            }
            iO.println(string + "  throw (Error)" + this.exceptionVar + ";");
        }
    }

    void tryTokenSequence(IO iO, String string, Token token, Token token2) {
        iO.println(string + "try {");
        SimpleNode.closeJJTreeComment(iO);
        Object object = token;
        while (object != token2.next) {
            TokenUtils.print((Token)object, iO, "jjtThis", this.nodeVar);
            object = ((Token)object).next;
        }
        SimpleNode.openJJTreeComment(iO, null);
        iO.println();
        object = this.production.throws_list.elements();
        this.insertCatchBlocks(iO, (Enumeration)object, string);
        iO.println(string + "} finally {");
        if (this.usesCloseNodeVar()) {
            iO.println(string + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(iO, string + "    ", true);
            iO.println(string + "  }");
        }
        iO.println(string + "}");
        SimpleNode.closeJJTreeComment(iO);
    }

    private static void findThrown(Hashtable hashtable, SimpleNode simpleNode) {
        String string;
        SimpleNode simpleNode2;
        if (simpleNode instanceof ASTBNFNonTerminal && (simpleNode2 = (ASTProduction)JJTreeGlobals.productions.get(string = simpleNode.getFirstToken().image)) != null) {
            Enumeration enumeration = simpleNode2.throws_list.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                hashtable.put(string2, string2);
            }
        }
        for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
            simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(i);
            NodeScope.findThrown(hashtable, simpleNode2);
        }
    }

    void tryExpansionUnit(IO iO, String string, SimpleNode simpleNode) {
        iO.println(string + "try {");
        SimpleNode.closeJJTreeComment(iO);
        simpleNode.print(iO);
        SimpleNode.openJJTreeComment(iO, null);
        iO.println();
        Hashtable hashtable = new Hashtable();
        NodeScope.findThrown(hashtable, simpleNode);
        Enumeration enumeration = hashtable.elements();
        this.insertCatchBlocks(iO, enumeration, string);
        iO.println(string + "} finally {");
        if (this.usesCloseNodeVar()) {
            iO.println(string + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(iO, string + "    ", true);
            iO.println(string + "  }");
        }
        iO.println(string + "}");
        SimpleNode.closeJJTreeComment(iO);
    }

    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).node_scope;
        }
        for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
            if (node2 instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)node2).node_scope;
            }
            if (node2 instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)node2).node_scope;
            }
            if (!(node2 instanceof ASTExpansionNodeScope)) continue;
            return ((ASTExpansionNodeScope)node2).node_scope;
        }
        return null;
    }
}

