/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.Folder;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.starteam.TreeBasedTask;

public class StarTeamCheckout
extends TreeBasedTask {
    private boolean createDirs = true;
    private boolean deleteUncontrolled = true;
    private int lockStatus = 3;

    public void setCreateWorkingDirs(boolean value) {
        this.createDirs = value;
    }

    public void setDeleteUncontrolled(boolean value) {
        this.deleteUncontrolled = value;
    }

    public void setLabel(String label) {
        this._setLabel(label);
    }

    public void setLocked(boolean v) throws BuildException {
        this.setLockStatus(v, 1);
    }

    public void setUnlocked(boolean v) throws BuildException {
        this.setLockStatus(v, 0);
    }

    private void setLockStatus(boolean v, int newStatus) throws BuildException {
        if (v) {
            if (this.lockStatus == 3) {
                this.lockStatus = newStatus;
            } else if (this.lockStatus != newStatus) {
                throw new BuildException("Error: cannot set locked and unlocked both true.");
            }
        }
    }

    protected View createSnapshotView(View raw) {
        int labelID = this.getLabelID(raw);
        if (labelID >= 0) {
            return new View(raw, ViewConfiguration.createFromLabel((int)labelID));
        }
        return new View(raw, ViewConfiguration.createTip());
    }

    protected void testPreconditions() throws BuildException {
        if (null != this.getRootLocalFolder() && !this.isForced()) {
            this.log("Warning: rootLocalFolder specified, but forcing off.", 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void visit(Folder starteamFolder, File targetFolder) throws BuildException {
        try {
            localFiles = TreeBasedTask.listLocalFiles(targetFolder);
            if (this.createDirs && !targetFolder.exists()) {
                targetFolder.mkdir();
            }
            files = starteamFolder.getItems("File");
            i = 0;
            while (i < files.length) {
                block11: {
                    block10: {
                        eachFile = (com.starbase.starteam.File)files[i];
                        filename = eachFile.getName();
                        localFile = new File(targetFolder, filename);
                        this.delistLocalFile(localFiles, localFile);
                        if (this.shouldProcess(filename)) break block10;
                        this.log("Skipping " + eachFile.toString(), 2);
                        break block11;
                    }
                    if (this.isForced()) ** GOTO lbl-1000
                    fileStatus = eachFile.getStatus();
                    if (fileStatus == 1 || fileStatus == 6) {
                        eachFile.updateStatus(true, true);
                        fileStatus = eachFile.getStatus();
                    }
                    if (fileStatus == 0) {
                        this.log("Not processing " + eachFile.toString() + " as it is current.", 2);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.log("Checking Out: " + localFile.toString(), 2);
                        eachFile.checkoutTo(localFile, this.lockStatus, true, true, true);
                    }
                }
                ++i;
            }
            subFolders = starteamFolder.getSubFolders();
            i = 0;
            while (i < subFolders.length) {
                targetSubfolder = new File(targetFolder, subFolders[i].getName());
                this.delistLocalFile(localFiles, targetSubfolder);
                if (this.isRecursive()) {
                    this.visit(subFolders[i], targetSubfolder);
                }
                ++i;
            }
            if (this.deleteUncontrolled) {
                this.deleteUncontrolledItems(localFiles);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void deleteUncontrolledItems(Hashtable localFiles) {
        try {
            Enumeration e = localFiles.keys();
            while (e.hasMoreElements()) {
                File file = new File(e.nextElement().toString());
                this.delete(file);
            }
        }
        catch (SecurityException e) {
            this.log("Error deleting file: " + e, 0);
        }
    }

    private boolean delete(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.delete(children[i]);
                ++i;
            }
        }
        this.log("Deleting: " + file.getAbsolutePath(), 2);
        return file.delete();
    }
}

