/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXSVGDocumentFactory
extends SAXDocumentFactory
implements SVGDocumentFactory {
    protected static final String DTDIDS = "org.apache.batik.dom.svg.resources.dtdids";
    protected static final String HTTP_CHARSET = "charset";
    protected static String dtdids;

    public SAXSVGDocumentFactory(String parser) {
        super(ExtensibleSVGDOMImplementation.getDOMImplementation(), parser);
    }

    public SAXSVGDocumentFactory(String parser, boolean dd) {
        super(ExtensibleSVGDOMImplementation.getDOMImplementation(), parser, dd);
    }

    public SVGDocument createSVGDocument(String uri) throws IOException {
        return (SVGDocument)this.createDocument(uri);
    }

    public SVGDocument createSVGDocument(String uri, InputStream inp) throws IOException {
        return (SVGDocument)this.createDocument(uri, inp);
    }

    public SVGDocument createSVGDocument(String uri, Reader r) throws IOException {
        return (SVGDocument)this.createDocument(uri, r);
    }

    public Document createDocument(String uri) throws IOException {
        int i;
        int eqIdx;
        ParsedURL purl = new ParsedURL(uri);
        InputStream is = purl.openStream(MimeTypeConstants.MIME_TYPES_SVG);
        InputSource isrc = new InputSource(is);
        String contentType = purl.getContentType();
        int cindex = -1;
        if (contentType != null) {
            contentType = contentType.toLowerCase();
            cindex = contentType.indexOf(HTTP_CHARSET);
        }
        if (cindex != -1 && (eqIdx = contentType.indexOf(61, i = cindex + HTTP_CHARSET.length())) != -1) {
            int idx = contentType.indexOf(44, ++eqIdx);
            int semiIdx = contentType.indexOf(59, eqIdx);
            if (semiIdx != -1 && (semiIdx < idx || idx == -1)) {
                idx = semiIdx;
            }
            String charset = idx != -1 ? contentType.substring(eqIdx, idx) : contentType.substring(eqIdx);
            isrc.setEncoding(charset.trim());
        }
        isrc.setSystemId(uri);
        Document doc = super.createDocument("http://www.w3.org/2000/svg", "svg", uri, isrc);
        try {
            ((SVGOMDocument)doc).setURLObject(new URL(purl.toString()));
        }
        catch (MalformedURLException mue) {
            throw new IOException("Malformed URL: " + uri);
        }
        return doc;
    }

    public Document createDocument(String uri, InputStream inp) throws IOException {
        Document doc;
        InputSource is = new InputSource(inp);
        is.setSystemId(uri);
        try {
            doc = super.createDocument("http://www.w3.org/2000/svg", "svg", uri, is);
            if (uri != null) {
                ((SVGOMDocument)doc).setURLObject(new URL(uri));
            }
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        return doc;
    }

    public Document createDocument(String uri, Reader r) throws IOException {
        Document doc;
        InputSource is = new InputSource(r);
        is.setSystemId(uri);
        try {
            doc = super.createDocument("http://www.w3.org/2000/svg", "svg", uri, is);
            if (uri != null) {
                ((SVGOMDocument)doc).setURLObject(new URL(uri));
            }
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        return doc;
    }

    public Document createDocument(String ns, String root, String uri) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(ns) || !"svg".equals(root)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(uri);
    }

    public Document createDocument(String ns, String root, String uri, InputStream is) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(ns) || !"svg".equals(root)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(uri, is);
    }

    public Document createDocument(String ns, String root, String uri, Reader r) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(ns) || !"svg".equals(root)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(uri, r);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.namespaces.put("", "http://www.w3.org/2000/svg");
        this.namespaces.put("xlink", "http://www.w3.org/1999/xlink");
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            if (dtdids == null) {
                ResourceBundle rb = ResourceBundle.getBundle(DTDIDS, Locale.getDefault());
                dtdids = rb.getString("publicIds");
            }
            if (publicId != null && dtdids.indexOf(publicId) != -1) {
                return new InputSource(this.getClass().getResource("resources/svg10.dtd").toString());
            }
        }
        catch (MissingResourceException e) {
            throw new SAXException(e);
        }
        return null;
    }

    static {
        DTDIDS = DTDIDS;
        HTTP_CHARSET = HTTP_CHARSET;
    }
}

