/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;

public class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    static final String[][] sJDBCTypes = new String[][]{{"HSQL Database Engine In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:."}, {"HSQL Database Engine Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:test"}, {"HSQL Database Engine Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost"}, {"HSQL Database Engine WebServer", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://localhost"}, {"JDBC-ODBC Brigde from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:test"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:test"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://localhost:1099/jdbc:cloudscape:test;create=true"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:sample.prp"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://localhost/sample"}};
    Connection mConnection;
    TextField mDriver;
    TextField mURL;
    TextField mUser;
    TextField mPassword;
    Label mError;

    public static Connection createConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver).newInstance();
        return DriverManager.getConnection(url, user, password);
    }

    ConnectionDialog(Frame owner, String title) {
        super(owner, title, true);
    }

    void create() {
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new GridLayout(6, 2, 10, 10));
        p.setBackground(SystemColor.control);
        p.add(ConnectionDialog.createLabel("Type:"));
        Choice types = new Choice();
        types.addItemListener(this);
        int i = 0;
        while (i < sJDBCTypes.length) {
            types.add(sJDBCTypes[i][0]);
            ++i;
        }
        p.add(types);
        p.add(ConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField("org.hsqldb.jdbcDriver");
        p.add(this.mDriver);
        p.add(ConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField("jdbc:hsqldb:.");
        p.add(this.mURL);
        p.add(ConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("sa");
        p.add(this.mUser);
        p.add(ConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.setEchoChar('*');
        p.add(this.mPassword);
        Button b = new Button("Ok");
        b.setActionCommand("ConnectOk");
        b.addActionListener(this);
        p.add(b);
        b = new Button("Cancel");
        b.setActionCommand("ConnectCancel");
        b.addActionListener(this);
        p.add(b);
        this.setLayout(new BorderLayout());
        this.add("East", ConnectionDialog.createLabel(""));
        this.add("West", ConnectionDialog.createLabel(""));
        this.mError = new Label("");
        Panel pMessage = ConnectionDialog.createBorderPanel(this.mError);
        this.add("South", pMessage);
        this.add("North", ConnectionDialog.createLabel(""));
        this.add("Center", p);
        this.doLayout();
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        ((Component)this).setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        this.show();
    }

    void trace(String s) {
        this.mError.setText(s);
        System.out.println(s);
    }

    public static Connection createConnection(Frame owner, String title) {
        ConnectionDialog dialog = new ConnectionDialog(owner, title);
        dialog.create();
        return dialog.mConnection;
    }

    public static Label createLabel(String s) {
        Label l = new Label(s);
        l.setBackground(SystemColor.control);
        return l;
    }

    public static Panel createBorderPanel(Component center) {
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add("Center", center);
        p.add("North", ConnectionDialog.createLabel(""));
        p.add("South", ConnectionDialog.createLabel(""));
        p.add("East", ConnectionDialog.createLabel(""));
        p.add("West", ConnectionDialog.createLabel(""));
        p.setBackground(SystemColor.control);
        return p;
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk")) {
            try {
                this.mConnection = ConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mError.setText(e.toString());
            }
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        int i = 0;
        while (i < sJDBCTypes.length) {
            if (s.equals(sJDBCTypes[i][0])) {
                this.mDriver.setText(sJDBCTypes[i][1]);
                this.mURL.setText(sJDBCTypes[i][2]);
            }
            ++i;
        }
    }
}

