/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.CharSet;

public class CharSetUtils {
    public static CharSet evaluateSet(String[] set) {
        return new CharSet(set);
    }

    public static String squeeze(String str, String set) {
        String[] strs = new String[]{set};
        return CharSetUtils.squeeze(str, strs);
    }

    public static String squeeze(String str, String[] set) {
        CharSet chars = CharSetUtils.evaluateSet(set);
        StringBuffer buffer = new StringBuffer(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        int lastChar = 32;
        int ch = 32;
        int i = 0;
        while (i < sz) {
            ch = chrs[i];
            if (!chars.contains((char)ch) || ch != lastChar || i == 0) {
                buffer.append((char)ch);
                lastChar = ch;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int count(String str, String set) {
        String[] strs = new String[]{set};
        return CharSetUtils.count(str, strs);
    }

    public static int count(String str, String[] set) {
        CharSet chars = CharSetUtils.evaluateSet(set);
        int count = 0;
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        int i = 0;
        while (i < sz) {
            if (chars.contains(chrs[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String delete(String str, String set) {
        String[] strs = new String[]{set};
        return CharSetUtils.delete(str, strs);
    }

    public static String delete(String str, String[] set) {
        CharSet chars = CharSetUtils.evaluateSet(set);
        StringBuffer buffer = new StringBuffer(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        int i = 0;
        while (i < sz) {
            if (!chars.contains(chrs[i])) {
                buffer.append(chrs[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String translate(String target, String repl, String with) {
        StringBuffer buffer = new StringBuffer(target.length());
        char[] chrs = target.toCharArray();
        char[] withChrs = with.toCharArray();
        int sz = chrs.length;
        int withMax = with.length() - 1;
        int i = 0;
        while (i < sz) {
            int idx = repl.indexOf(chrs[i]);
            if (idx != -1) {
                if (idx > withMax) {
                    idx = withMax;
                }
                buffer.append(withChrs[idx]);
            } else {
                buffer.append(chrs[i]);
            }
            ++i;
        }
        return buffer.toString();
    }
}

