/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.testng.IClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.Parameters;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.log.TextFormatter;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String[] stringToArray(String s) {
        StringTokenizer st = new StringTokenizer(s, " ,");
        String[] result = new String[st.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = st.nextToken();
        }
        return result;
    }

    public static Class[] xmlClassesToClasses(List<XmlClass> classes) {
        ArrayList<Class> result = new ArrayList<Class>();
        for (XmlClass xmlClass : classes) {
            result.add(xmlClass.getSupportClass());
        }
        Class[] xmlClasses = result.toArray(new Class[classes.size()]);
        HashMap<Class, Class> withNestedClasses = new HashMap<Class, Class>();
        Utils.findAllClasses(xmlClasses, withNestedClasses);
        return withNestedClasses.values().toArray(new Class[withNestedClasses.size()]);
    }

    public static XmlClass[] classesToXmlClasses(Class[] classes) {
        ArrayList<XmlClass> result = new ArrayList<XmlClass>();
        for (Class cls : classes) {
            result.add(new XmlClass(cls));
        }
        return result.toArray(new XmlClass[classes.length]);
    }

    private static boolean isIncluded(String name, List<String> included, List<String> excluded) {
        boolean result = false;
        if (included.size() == 0 && excluded.size() == 0) {
            result = true;
        } else {
            boolean isIncluded = Utils.find(name, included);
            boolean isExcluded = Utils.find(name, excluded);
            result = isIncluded && !isExcluded ? true : (isExcluded ? false : included.size() == 0);
        }
        return result;
    }

    private static boolean find(String name, List<String> list) {
        for (String regexpStr : list) {
            if (!Pattern.matches(regexpStr, name)) continue;
            return true;
        }
        return false;
    }

    public static String[] findClassesInPackage(String packageName, List<String> included, List<String> excluded) throws IOException {
        String packageOnly = packageName;
        boolean recursive = false;
        if (packageName.endsWith(".*")) {
            packageOnly = packageName.substring(0, packageName.lastIndexOf(".*"));
            recursive = true;
        }
        ArrayList<String> vResult = new ArrayList<String>();
        String packageDirName = packageOnly.replace('.', '/');
        Enumeration<URL> dirs = Utils.class.getClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                Utils.findClassesInDirPackage(packageOnly, included, excluded, URLDecoder.decode(url.getFile(), "UTF-8"), recursive, vResult);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                Utils.ppp("PACKAGE NAME IS " + packageName);
                if (idx != -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                Utils.ppp("INCLUDE OR EXCLUDE " + packageName + "." + className);
                Utils.includeOrExcludeClass(packageName, className, included, excluded, vResult);
            }
        }
        String[] result = vResult.toArray(new String[vResult.size()]);
        return result;
    }

    private static void findClassesInDirPackage(String packageName, List<String> included, List<String> excluded, String packagePath, final boolean recursive, List<String> classes) {
        File[] dirfiles;
        File dir2 = new File(packagePath);
        if (!dir2.exists() || !dir2.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                Utils.findClassesInDirPackage(packageName + "." + file.getName(), included, excluded, file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            Utils.includeOrExcludeClass(packageName, className, included, excluded, classes);
        }
    }

    private static void includeOrExcludeClass(String packageName, String className, List<String> included, List<String> excluded, List<String> classes) {
        if (Utils.isIncluded(className, included, excluded)) {
            Utils.log("", 2, "Including class " + className);
            classes.add(packageName + '.' + className);
        } else {
            Utils.log("", 2, "Excluding class " + className);
        }
    }

    private static void findAllClasses(Class[] classes, Map<Class, Class> result) {
        for (Class cls : classes) {
            if (result.containsKey(cls)) continue;
            result.put(cls, cls);
        }
    }

    public static String[] parseMultiLine(String line) {
        ArrayList<String> vResult = new ArrayList<String>();
        if (null != line && !"".equals(line.trim())) {
            StringTokenizer st = new StringTokenizer(line, " ");
            while (st.hasMoreTokens()) {
                vResult.add(st.nextToken());
            }
        }
        String[] result = vResult.toArray(new String[vResult.size()]);
        return result;
    }

    public static void writeFile(String outputDir, String fileName, StringBuffer sb) {
        Utils.writeFile(outputDir, fileName, sb.toString());
    }

    public static void writeFile(String outputDir, String fileName, String sb) {
        Utils.writeFile(new File(outputDir), fileName, sb);
    }

    public static void writeFile(File outDir, String fileName, String sb) {
        try {
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            File outputFile = new File(outDir, fileName);
            outputFile.delete();
            outputFile.createNewFile();
            Utils.writeFile(outputFile, sb);
        }
        catch (IOException e) {
            if (TestRunner.getVerbose() > 1) {
                e.printStackTrace();
            }
            Utils.log("[Utils]", 1, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File outputFile, String sb) {
        BufferedWriter fw = null;
        try {
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            fw = new BufferedWriter(new FileWriter(outputFile, false));
            fw.write(sb);
            Utils.log("", 2, "Creating " + outputFile.getAbsolutePath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void ppp(String s) {
        System.out.println("[Utils] " + s);
    }

    public static void dumpMap(Map result) {
        System.out.println("vvvvv");
        for (Object key : result.keySet()) {
            Object value = result.get(key);
            System.out.println(key + " => " + value);
        }
        System.out.println("^^^^^");
    }

    public static void dumpMethods(List<ITestNGMethod> allMethods) {
        Utils.ppp("======== METHODS:");
        for (ITestNGMethod tm : allMethods) {
            Utils.ppp("  " + tm);
        }
    }

    public static String[] dependentGroupsForThisMethodForTest(Method m, IAnnotationFinder finder) {
        ITest tm;
        ArrayList<String> vResult = new ArrayList<String>();
        Class<?> cls = m.getDeclaringClass();
        ITest tc = AnnotationHelper.findTest(finder, cls);
        if (null != tc) {
            for (String group : tc.getDependsOnGroups()) {
                vResult.add(group);
            }
        }
        if (null != (tm = AnnotationHelper.findTest(finder, m))) {
            String[] groups;
            for (String group : groups = tm.getDependsOnGroups()) {
                vResult.add(group);
            }
        }
        return vResult.toArray(new String[vResult.size()]);
    }

    public static String[] groupsForThisMethodForTest(Method m, IAnnotationFinder finder) {
        ITest tm;
        ArrayList<String> vResult = new ArrayList<String>();
        Class<?> cls = m.getDeclaringClass();
        ITest tc = AnnotationHelper.findTest(finder, cls);
        if (null != tc) {
            for (String group : tc.getGroups()) {
                vResult.add(group);
            }
        }
        if (null != (tm = AnnotationHelper.findTest(finder, m))) {
            String[] groups;
            for (String group : groups = tm.getGroups()) {
                vResult.add(group);
            }
        }
        return vResult.toArray(new String[vResult.size()]);
    }

    public static String[] groupsForThisMethodForConfiguration(Method m, IAnnotationFinder finder) {
        String[] result = new String[]{};
        ArrayList vResult = new ArrayList();
        Class<?> cls = m.getDeclaringClass();
        ITest tm = AnnotationHelper.findTest(finder, m);
        if (null != tm) {
            result = tm.getGroups();
        }
        return result;
    }

    public static String[] dependentGroupsForThisMethodForConfiguration(Method m, IAnnotationFinder finder) {
        String[] result = new String[]{};
        ArrayList vResult = new ArrayList();
        Class<?> cls = m.getDeclaringClass();
        IConfiguration tm = AnnotationHelper.findConfiguration(finder, m);
        if (null != tm) {
            result = tm.getDependsOnGroups();
        }
        return result;
    }

    public static void log(String cls, int level, String msg) {
        if (TestRunner.getVerbose() >= level) {
            if (cls.length() > 0) {
                System.out.println("[" + cls + "] " + msg);
            } else {
                System.out.println(msg);
            }
        }
    }

    public static void error(String errorMessage) {
        System.err.println("[Error] " + errorMessage);
    }

    public static int calculateInvokedMethodCount(ITestNGMethod[] methods) {
        int result = 0;
        for (ITestNGMethod method : methods) {
            int instanceCount = method.getInvocationCount();
            result += instanceCount;
        }
        return result;
    }

    public static int calculateInvokedMethodCount(Map<ITestNGMethod, ITestResult> methods) {
        return Utils.calculateInvokedMethodCount(methods.keySet().toArray(new ITestNGMethod[methods.values().size()]));
    }

    public static Object createInstance(Class declaringClass, Map<Class, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder) {
        Object result = null;
        try {
            Constructor constructor = Utils.findAnnotatedConstructor(finder, declaringClass);
            if (null != constructor) {
                IParameters annotation = (IParameters)finder.findAnnotation(constructor, IParameters.class);
                String[] parameterNames = annotation.getValue();
                Object[] parameters = Parameters.createParameters(constructor, "@Parameters", parameterNames, (Map<String, String>)xmlTest.getParameters());
                result = constructor.newInstance(parameters);
            } else {
                boolean isStatic;
                Class[] parameterTypes = new Class[]{};
                Object[] parameters = new Object[]{};
                Class ec = Utils.getEnclosingClass(declaringClass);
                boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
                if (null != ec && !isStatic) {
                    parameterTypes = new Class[]{ec};
                    IClass enclosingIClass = classes.get(ec);
                    Object[] enclosingInstances = null;
                    if (null != enclosingIClass) {
                        enclosingInstances = enclosingIClass.getInstances(false);
                        if (null == enclosingInstances || enclosingInstances.length == 0) {
                            Object o = ec.newInstance();
                            enclosingIClass.addInstance(o);
                            enclosingInstances = new Object[]{o};
                        }
                    } else {
                        enclosingInstances = new Object[]{ec.newInstance()};
                    }
                    Object enclosingClassInstance = enclosingInstances[0];
                    parameters = new Object[]{enclosingClassInstance};
                }
                Constructor ct = declaringClass.getDeclaredConstructor(parameterTypes);
                result = ct.newInstance(parameters);
            }
        }
        catch (TestNGException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Utils.ppp("FAILED TO CREATE CLASS " + declaringClass);
            throw new TestNGException(ex);
        }
        catch (IllegalAccessException ex) {
            result = Utils.tryOtherConstructor(declaringClass);
        }
        catch (NoSuchMethodException ex) {
            result = Utils.tryOtherConstructor(declaringClass);
        }
        catch (InstantiationException ex) {
            result = Utils.tryOtherConstructor(declaringClass);
        }
        catch (Exception ex) {
            throw new TestNGException(ex);
        }
        return result;
    }

    private static Class getEnclosingClass(Class declaringClass) {
        Class<?> result = null;
        String className = declaringClass.getName();
        int index = className.indexOf("$");
        if (index != -1) {
            String ecn = className.substring(0, index);
            try {
                result = Class.forName(ecn);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Object tryOtherConstructor(Class declaringClass) {
        Object result = null;
        try {
            Constructor ctor = declaringClass.getConstructor(String.class);
            result = ctor.newInstance("Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            throw new TestNGException("Error creating the test class " + declaringClass + (message != null ? ": " + message : ""));
        }
        return result;
    }

    private static Constructor findAnnotatedConstructor(IAnnotationFinder finder, Class declaringClass) {
        Constructor<?>[] constructors = declaringClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] parameterTypes;
            Constructor<?> result = constructors[i];
            IParameters annotation = (IParameters)finder.findAnnotation(result, IParameters.class);
            if (null == annotation) continue;
            String[] parameters = annotation.getValue();
            if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                throw new TestNGException("Parameter count mismatch:  " + result + "\naccepts " + parameterTypes.length + " parameters but the @Test annotation declares " + parameters.length);
            }
            return result;
        }
        return null;
    }

    public static String[] split(String string, String sep) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int start = 0;
        int idx = string.indexOf(sep, start);
        int len = sep.length();
        ArrayList<String> strings = new ArrayList<String>();
        while (idx != -1) {
            strings.add(string.substring(start, idx).trim());
            start = idx + len;
            idx = string.indexOf(sep, start);
        }
        strings.add(string.substring(start).trim());
        return strings.toArray(new String[strings.size()]);
    }

    public static void initLogger(Logger logger, String outputLogPath) {
        try {
            logger.setUseParentHandlers(false);
            FileHandler fh = new FileHandler(outputLogPath);
            fh.setFormatter(new TextFormatter());
            fh.setLevel(Level.INFO);
            logger.addHandler(fh);
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void logInvocation(String reason, Method thisMethod, Object[] parameters) {
        String clsName = thisMethod.getDeclaringClass().getName();
        int n = clsName.lastIndexOf(".");
        if (n >= 0) {
            clsName = clsName.substring(n + 1);
        }
        String methodName = clsName + "." + thisMethod.getName();
        if (TestRunner.getVerbose() >= 2) {
            StringBuffer paramString = new StringBuffer();
            if (parameters != null) {
                for (Object p : parameters) {
                    paramString.append(p.toString()).append(" ");
                }
            }
            Utils.log("", 2, "Invoking " + reason + methodName + "(" + paramString + ")");
        }
    }
}

