/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.resource.cached;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.ResourceBuilderImpl;
import org.ajax4jsf.framework.resource.ResourceNotFoundException;
import org.ajax4jsf.framework.resource.cached.DualLRUMap;
import org.ajax4jsf.framework.resource.cached.ResourceBean;
import org.ajax4jsf.framework.resource.cached.ResourceBytesDataBean;
import org.ajax4jsf.framework.resource.cached.ResourceDataBean;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedResourceBuilder
extends ResourceBuilderImpl {
    private static final Log log = LogFactory.getLog((Class)CachedResourceBuilder.class);
    private static final int DEFAULT_CAPACITY = 10000;
    private long counter = 0L;
    private DualLRUMap cache;

    protected byte[] decrypt(byte[] data) {
        return data;
    }

    protected byte[] encrypt(byte[] data) {
        return data;
    }

    public Object getResourceDataForKey(String key) {
        ResourceBean bean = (ResourceBean)this.cache.get(key);
        if (null == bean) {
            throw new ResourceNotFoundException("Resource for key " + key + "not present in cache");
        }
        return bean.getData();
    }

    public InternetResource getResourceForKey(String key) throws ResourceNotFoundException {
        ResourceBean bean = (ResourceBean)this.cache.get(key);
        if (null == bean) {
            throw new ResourceNotFoundException("Resource for key " + key + "not present in cache");
        }
        return super.getResourceForKey(bean.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUri(InternetResource resource, FacesContext facesContext, Object data) {
        ResourceBean bean = null == data ? new ResourceBean(resource.getKey()) : (data instanceof byte[] ? new ResourceBytesDataBean(resource.getKey(), (byte[])data) : new ResourceDataBean(resource.getKey(), data));
        String key = (String)this.cache.getKey(bean);
        if (null == key) {
            CachedResourceBuilder cachedResourceBuilder = this;
            synchronized (cachedResourceBuilder) {
                ++this.counter;
                key = bean.hashCode() + "c" + this.counter;
            }
            this.cache.put(key, bean);
        } else {
            this.cache.get(key);
        }
        String resourceURL = this.getFacesResourceURL(facesContext, key);
        if (resource.isSessionAware()) {
            resourceURL = facesContext.getExternalContext().encodeResourceURL(resourceURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("BUILD_RESOURCE_URI_INFO", resource.getKey(), resourceURL));
        }
        return resourceURL;
    }

    public void init() throws FacesException {
        super.init();
        Properties properties = this.getProperties("cache.properties");
        int capacity = 10000;
        String capacityString = properties.getProperty("cache.capacity");
        if (null != capacityString) {
            try {
                capacity = Integer.parseInt(capacityString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Error parsing value of parameters cache capacity, use default value 10000", (Throwable)e);
            }
        }
        this.cache = new DualLRUMap(capacity);
        this.counter = this.getStartTime() - 1158760000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        Properties properties = new Properties();
        InputStream props = CachedResourceBuilder.class.getResourceAsStream(name);
        if (null != props) {
            try {
                properties.load(props);
            }
            catch (IOException e) {
                log.warn((Object)Messages.getMessage("READING_PROPERTIES_ERROR", name), (Throwable)e);
            }
            finally {
                try {
                    props.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }
}

