/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.params;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultHttpParams
implements HttpParams,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(DefaultHttpParams.class);
    private static HttpParamsFactory httpParamsFactory = new DefaultHttpParamsFactory();
    private HttpParams defaults = null;
    private HashMap parameters = null;

    public static HttpParams getDefaultParams() {
        return httpParamsFactory.getDefaultParams();
    }

    public static void setHttpParamsFactory(HttpParamsFactory httpParamsFactory) {
        if (httpParamsFactory == null) {
            throw new IllegalArgumentException("httpParamsFactory may not be null");
        }
        DefaultHttpParams.httpParamsFactory = httpParamsFactory;
    }

    public DefaultHttpParams(HttpParams httpParams) {
        this.defaults = httpParams;
    }

    public DefaultHttpParams() {
        this(DefaultHttpParams.getDefaultParams());
    }

    public synchronized HttpParams getDefaults() {
        return this.defaults;
    }

    public synchronized void setDefaults(HttpParams httpParams) {
        this.defaults = httpParams;
    }

    public synchronized Object getParameter(String string) {
        Object var2_2 = null;
        if (this.parameters != null) {
            var2_2 = this.parameters.get(string);
        }
        if (var2_2 != null) {
            return var2_2;
        }
        if (this.defaults != null) {
            return this.defaults.getParameter(string);
        }
        return null;
    }

    public synchronized void setParameter(String string, Object object) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(string, object);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set parameter " + string + " = " + object));
        }
    }

    public synchronized void setParameters(String[] stringArray, Object object) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.setParameter(stringArray[i], object);
        }
    }

    public long getLongParameter(String string, long l) {
        Object object = this.getParameter(string);
        if (object == null) {
            return l;
        }
        return (Long)object;
    }

    public void setLongParameter(String string, long l) {
        this.setParameter(string, new Long(l));
    }

    public int getIntParameter(String string, int n) {
        Object object = this.getParameter(string);
        if (object == null) {
            return n;
        }
        return (Integer)object;
    }

    public void setIntParameter(String string, int n) {
        this.setParameter(string, new Integer(n));
    }

    public double getDoubleParameter(String string, double d) {
        Object object = this.getParameter(string);
        if (object == null) {
            return d;
        }
        return (Double)object;
    }

    public void setDoubleParameter(String string, double d) {
        this.setParameter(string, new Double(d));
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        Object object = this.getParameter(string);
        if (object == null) {
            return bl;
        }
        return (Boolean)object;
    }

    public void setBooleanParameter(String string, boolean bl) {
        this.setParameter(string, new Boolean(bl));
    }

    public boolean isParameterSet(String string) {
        return this.getParameter(string) != null;
    }

    public boolean isParameterSetLocally(String string) {
        return this.parameters != null && this.parameters.get(string) != null;
    }

    public boolean isParameterTrue(String string) {
        return this.getBooleanParameter(string, false);
    }

    public boolean isParameterFalse(String string) {
        return !this.getBooleanParameter(string, false);
    }

    public void clear() {
        this.parameters = null;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultHttpParams defaultHttpParams = (DefaultHttpParams)super.clone();
        if (this.parameters != null) {
            defaultHttpParams.parameters = (HashMap)this.parameters.clone();
        }
        defaultHttpParams.setDefaults(this.defaults);
        return defaultHttpParams;
    }
}

