/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.tx;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jms.delegate.Ack;
import org.jboss.jms.delegate.DefaultAck;
import org.jboss.jms.delegate.DeliveryInfo;
import org.jboss.jms.message.JBossMessage;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.impl.message.MessageFactory;

public class ClientTransaction {
    private static final Logger log = Logger.getLogger(ClientTransaction.class);
    public static final byte TX_OPEN = 0;
    public static final byte TX_ENDED = 1;
    public static final byte TX_PREPARED = 2;
    public static final byte TX_COMMITED = 3;
    public static final byte TX_ROLLEDBACK = 4;
    private static boolean trace = log.isTraceEnabled();
    private byte state = 0;
    private Map sessionStatesMap;
    private List sessionStatesList;
    private boolean clientSide = true;
    private boolean recovered;

    public ClientTransaction() {
        this(false);
    }

    public ClientTransaction(boolean isRecovered) {
        this.recovered = isRecovered;
    }

    public byte getState() {
        return this.state;
    }

    public void addMessage(String sessionId, JBossMessage msg) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        SessionTxState sessionTxState = this.getSessionTxState(sessionId);
        sessionTxState.addMessage(msg);
    }

    public void addAck(String sessionId, DeliveryInfo info) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        SessionTxState sessionTxState = this.getSessionTxState(sessionId);
        sessionTxState.addAck(info);
    }

    public void clearMessages() {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        if (this.sessionStatesMap != null) {
            for (SessionTxState sessionTxState : this.sessionStatesMap.values()) {
                sessionTxState.clearMessages();
            }
        }
    }

    public void setState(byte state) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        this.state = state;
    }

    public List getSessionStates() {
        if (this.sessionStatesList != null) {
            return this.sessionStatesList;
        }
        return this.sessionStatesMap == null ? Collections.EMPTY_LIST : new ArrayList(this.sessionStatesMap.values());
    }

    public void handleFailover(int newServerID, String oldSessionID, String newSessionID) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        LinkedHashMap<String, SessionTxState> tmpMap = null;
        if (this.sessionStatesMap != null) {
            for (SessionTxState state : this.sessionStatesMap.values()) {
                boolean handled = state.handleFailover(newServerID, oldSessionID, newSessionID);
                if (!handled) continue;
                if (tmpMap == null) {
                    tmpMap = new LinkedHashMap<String, SessionTxState>();
                }
                tmpMap.put(newSessionID, state);
            }
        }
        if (tmpMap != null) {
            this.sessionStatesMap = tmpMap;
        }
    }

    public List getDeliveriesForSession(String sessionID) {
        if (!this.clientSide) {
            throw new IllegalStateException("Cannot call this method on the server side");
        }
        if (this.sessionStatesMap == null) {
            return Collections.EMPTY_LIST;
        }
        SessionTxState state = (SessionTxState)this.sessionStatesMap.get(sessionID);
        if (state != null) {
            List list = state.getAcks();
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public void setRecovered(boolean b) {
        this.recovered = b;
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeByte(this.state);
        if (this.sessionStatesMap == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.sessionStatesMap.size());
            for (SessionTxState state : this.sessionStatesMap.values()) {
                out.writeUTF(state.getSessionId());
                List msgs = state.getMsgs();
                out.writeInt(msgs.size());
                for (JBossMessage m : msgs) {
                    out.writeByte(m.getType());
                    m.write(out);
                }
                List acks = state.getAcks();
                for (DeliveryInfo ack : acks) {
                    if (!ack.isShouldAck()) continue;
                    out.writeLong(ack.getMessageProxy().getDeliveryId());
                }
                out.writeLong(Long.MIN_VALUE);
            }
        }
        out.writeBoolean(this.recovered);
    }

    public void read(DataInputStream in) throws Exception {
        this.clientSide = false;
        this.state = in.readByte();
        int numSessions = in.readInt();
        this.sessionStatesList = new ArrayList(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            long l;
            String sessionId = in.readUTF();
            SessionTxState sessionState = new SessionTxState(sessionId);
            this.sessionStatesList.add(sessionState);
            int numMsgs = in.readInt();
            for (int j = 0; j < numMsgs; ++j) {
                byte type = in.readByte();
                JBossMessage msg = (JBossMessage)MessageFactory.createMessage(type);
                msg.read(in);
                sessionState.addMessage(msg);
            }
            while ((l = in.readLong()) != Long.MIN_VALUE) {
                sessionState.addAck(new DefaultAck(l));
            }
        }
        this.recovered = in.readBoolean();
    }

    private SessionTxState getSessionTxState(String sessionID) {
        SessionTxState sessionTxState;
        if (this.sessionStatesMap == null) {
            this.sessionStatesMap = new LinkedHashMap();
        }
        if ((sessionTxState = (SessionTxState)this.sessionStatesMap.get(sessionID)) == null) {
            sessionTxState = new SessionTxState(sessionID);
            this.sessionStatesMap.put(sessionID, sessionTxState);
        }
        return sessionTxState;
    }

    public void mergeIn(ClientTransaction toMerge) {
        this.state = toMerge.state;
        if (toMerge.sessionStatesMap != null) {
            if (this.sessionStatesMap == null) {
                this.sessionStatesMap = new LinkedHashMap();
            }
            for (Object key : toMerge.sessionStatesMap.keySet()) {
                SessionTxState ss = (SessionTxState)toMerge.sessionStatesMap.get(key);
                if (this.sessionStatesMap.get(key) == null) {
                    this.sessionStatesMap.put(key, ss);
                    continue;
                }
                SessionTxState orig = (SessionTxState)this.sessionStatesMap.get(key);
                List acksToMerge = ss.getAcks();
                if (acksToMerge == null) continue;
                for (Ack ack : acksToMerge) {
                    if (orig.getAcks().contains(ack)) continue;
                    orig.getAcks().add(ack);
                }
            }
            this.sessionStatesList = this.sessionStatesMap == null ? Collections.EMPTY_LIST : new ArrayList(this.sessionStatesMap.values());
        }
    }

    public class SessionTxState {
        private String sessionID;
        private int serverID = -1;
        private List msgs = new ArrayList();
        private List acks = new ArrayList();

        SessionTxState(String sessionID) {
            this.sessionID = sessionID;
        }

        void addMessage(JBossMessage msg) {
            this.msgs.add(msg);
        }

        void addAck(Ack ack) {
            this.acks.add(ack);
        }

        public List getMsgs() {
            return this.msgs;
        }

        public List getAcks() {
            return this.acks;
        }

        public String getSessionId() {
            return this.sessionID;
        }

        public void setAcks(List acks) {
            this.acks = acks;
        }

        boolean handleFailover(int newServerID, String oldSessionID, String newSessionID) {
            if (this.sessionID.equals(oldSessionID) && this.serverID != newServerID) {
                this.sessionID = newSessionID;
                this.serverID = newServerID;
                Iterator i = this.acks.iterator();
                while (i.hasNext()) {
                    DeliveryInfo di = (DeliveryInfo)i.next();
                    if (di.getMessageProxy().getMessage().isReliable()) continue;
                    if (trace) {
                        log.trace((Object)(this + " discarded non-persistent " + di + " on failover"));
                    }
                    i.remove();
                }
                return true;
            }
            return false;
        }

        void clearMessages() {
            this.msgs.clear();
        }
    }
}

