/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.spi.Activation;

public class AgendaEventSupport
implements Serializable {
    private static final long serialVersionUID = 9072017367081307109L;
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private final WorkingMemory workingMemory;

    public AgendaEventSupport(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void addEventListener(AgendaEventListener agendaEventListener) {
        if (!this.listeners.contains(agendaEventListener)) {
            this.listeners.add(agendaEventListener);
        }
    }

    public void removeEventListener(AgendaEventListener agendaEventListener) {
        this.listeners.remove(agendaEventListener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireActivationCreated(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCreatedEvent activationCreatedEvent = new ActivationCreatedEvent(activation);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).activationCreated(activationCreatedEvent);
        }
    }

    public void fireActivationCancelled(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCancelledEvent activationCancelledEvent = new ActivationCancelledEvent(activation);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).activationCancelled(activationCancelledEvent);
        }
    }

    public void fireBeforeActivationFired(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeActivationFiredEvent beforeActivationFiredEvent = new BeforeActivationFiredEvent(activation);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).beforeActivationFired(beforeActivationFiredEvent);
        }
    }

    public void fireAfterActivationFired(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterActivationFiredEvent afterActivationFiredEvent = new AfterActivationFiredEvent(activation);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((AgendaEventListener)this.listeners.get(i)).afterActivationFired(afterActivationFiredEvent);
        }
    }
}

