/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.portlet;

import com.icesoft.faces.env.AuthenticationVerifier;
import com.icesoft.faces.env.CommonEnvironmentRequest;
import com.icesoft.faces.env.RequestAttributes;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.portlet.AllowMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;

public abstract class PortletEnvironmentRenderRequest
extends CommonEnvironmentRequest
implements RenderRequest {
    private static final Collection PersistentRequestConstants = Arrays.asList("javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path", "javax.portlet.config", "javax.portlet.userinfo");
    private static final Collection RequestConstants = Arrays.asList("javax.portlet.request", "javax.portlet.response");
    private PortletMode portletMode;
    private WindowState windowState;
    private PortletPreferences portletPreferences;
    private PortletSession portletSession;
    private PortalContext portalContext;
    private String responseContentType;
    private ArrayList responseContentTypes;
    private Map properties;
    private Map pseudoAPIAttributes;

    public PortletEnvironmentRenderRequest(PortletSession session, RenderRequest request, Configuration configuration) {
        this.portletSession = session;
        this.portletMode = request.getPortletMode();
        this.windowState = request.getWindowState();
        this.portletPreferences = request.getPreferences();
        this.portalContext = request.getPortalContext();
        this.responseContentType = request.getResponseContentType();
        this.responseContentTypes = Collections.list(request.getResponseContentTypes());
        this.authType = request.getAuthType();
        this.remoteUser = request.getRemoteUser();
        this.userPrincipal = request.getUserPrincipal();
        this.requestedSessionId = request.getRequestedSessionId();
        this.requestedSessionIdValid = request.isRequestedSessionIdValid();
        this.scheme = request.getScheme();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.secure = request.isSecure();
        this.contextPath = request.getContextPath();
        String customPortletAttributes = configuration.getAttribute("portlet.hiddenAttributes", configuration.getAttribute("hiddenPortletAttributes", ""));
        List<String> hiddenCustomAttributeNames = Arrays.asList(customPortletAttributes.split(" "));
        this.attributes = Collections.synchronizedMap(new HashMap());
        PortletEnvironmentRenderRequest.populateMap(Collections.list(request.getAttributeNames()), this.attributes, request);
        PortletEnvironmentRenderRequest.populateMap(PersistentRequestConstants, this.attributes, request);
        PortletEnvironmentRenderRequest.populateMap(RequestConstants, this.attributes, request);
        PortletEnvironmentRenderRequest.populateMap(hiddenCustomAttributeNames, this.attributes, request);
        this.pseudoAPIAttributes = new HashMap();
        PortletEnvironmentRenderRequest.populateMap(PersistentRequestConstants, this.pseudoAPIAttributes, request);
        PortletEnvironmentRenderRequest.populateMap(hiddenCustomAttributeNames, this.pseudoAPIAttributes, request);
        this.parameters = new HashMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.parameters.put(name, request.getParameterValues(name));
        }
        this.properties = new HashMap();
        Enumeration propertyNames = request.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Enumeration values = request.getProperties(name);
            this.properties.put(name, Collections.list(values));
        }
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return this.allowMode().isWindowStateAllowed(windowState);
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        return this.allowMode().isPortletModeAllowed(portletMode);
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public PortletPreferences getPreferences() {
        return this.portletPreferences;
    }

    public PortletSession getPortletSession() {
        return this.portletSession;
    }

    public PortletSession getPortletSession(boolean create) {
        return this.portletSession;
    }

    public String getProperty(String name) {
        if (this.properties.containsKey(name)) {
            LinkedList values = (LinkedList)this.properties.get(name);
            return (String)values.get(0);
        }
        return null;
    }

    public Enumeration getProperties(String name) {
        if (this.properties.containsKey(name)) {
            LinkedList values = (LinkedList)this.properties.get(name);
            return Collections.enumeration(values);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getPropertyNames() {
        return Collections.enumeration(this.properties.keySet());
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public boolean isUserInRole(String string) {
        return this.authenticationVerifier().isUserInRole(string);
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public Enumeration getResponseContentTypes() {
        return Collections.enumeration(this.responseContentTypes);
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.requestAttributes().removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        this.requestAttributes().setAttribute(name, value);
    }

    public abstract AllowMode allowMode();

    public abstract AuthenticationVerifier authenticationVerifier();

    public abstract RequestAttributes requestAttributes();

    void repopulatePseudoAPIAttributes() {
        this.attributes.putAll(this.pseudoAPIAttributes);
    }

    private static void populateMap(Collection keys, Map map, RenderRequest request) {
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Object value = request.getAttribute(name);
            if (name == null || value == null) continue;
            map.put(name, value);
        }
    }
}

