/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp2290.unit;

import javax.ejb.SessionSynchronization;
import javax.naming.Context;
import javax.naming.InitialContext;

import junit.framework.Test;
import junit.framework.TestCase;

import org.jboss.ejb3.test.common.EJB3TestCase;

import org.jboss.ejb3.test.jbpapp2290.ImplementsSessionSynchronizationBean;
import org.jboss.ejb3.test.jbpapp2290.ImplementsSessionSynchronizationRemoteBusiness;
import org.jboss.ejb3.test.jbpapp2290.ImplementsSessionSynchronizationBMTBean;
import org.jboss.ejb3.test.jbpapp2290.ImplementsSessionSynchronizationBMTRemoteBusiness;
import org.jboss.logging.Logger;

/**
 * ImplementsSessionSynchronizationUnitTestCase
 * 
 * Test Cases to validate JBPAPP-2290 (incorporates EJBTHREE-995)
 * is resolved
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @author <a href="mailto:tkobayas@redhat.com">Toshiya Kobayashi</a>
 * @version $Revision: 102090 $
 */
public class ImplementsSessionSynchronizationUnitTestCase extends EJB3TestCase
{
   // --------------------------------------------------------------------------------||
   // Class Members ------------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   private static final Logger log = Logger.getLogger(ImplementsSessionSynchronizationUnitTestCase.class);

   private ImplementsSessionSynchronizationRemoteBusiness sfsb;

   // --------------------------------------------------------------------------------||
   // Tests --------------------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   public ImplementsSessionSynchronizationUnitTestCase(String name) {
      super(name);
   }

   /**
    * Tests that an invocation to a SFSB implementing SessionSynchronization for CMT
    * does not result in 2 calls to any of the SessionSynchronization callbacks
    */
   public void testSfsbImplementingSessionSynchronizationForDoubleCallbacks() throws Throwable
   {
      // Define JNDI Target for Lookup
      String jndiName = ImplementsSessionSynchronizationBean.class.getSimpleName() + "/" + "remote";

      // Get JNDI Context
      Context context = new InitialContext();

      // Obtain
      sfsb = (ImplementsSessionSynchronizationRemoteBusiness) context
            .lookup(jndiName);

      // Check callbacks are reset
      this.assertCallbacksReset();

      // Invoke
      sfsb.call();

      // Check callbacks have been made exactly once
      this.assertCallsExpected(1);
      
      // Invoke again
      sfsb.call();

      // Check callbacks have been made exactly twice
      this.assertCallsExpected(2);      
      
      // Invoke again
      sfsb.call();

      // Check callbacks have been made exactly three times
      this.assertCallsExpected(3);  

      // Reset
      sfsb.resetCounters();

      // Check callbacks are reset
      this.assertCallbacksReset();
   }

   /**
    * Tests that an invocation to a SFSB implementing SessionSynchronization for BMT
    * does not result in duplicate calls to the SessionSynchronization callbacks after multiple method invocations within Tx.
    */
   public void testSfsbImplementingSessionSynchronizationBMTForDoubleCallbacks() throws Throwable
   {
      // Define JNDI Target for Lookup
      String jndiName = ImplementsSessionSynchronizationBMTBean.class.getSimpleName() + "/" + "remote";

      // Get JNDI Context
      Context context = new InitialContext();

      // Obtain
      sfsb = (ImplementsSessionSynchronizationBMTRemoteBusiness) context
            .lookup(jndiName);

      // Check callbacks are reset
      this.assertCallbacksReset();

      // begin Tx
      ((ImplementsSessionSynchronizationBMTRemoteBusiness)sfsb).beginTx();

      // Invoke 3times
      sfsb.call();
      sfsb.call();
      sfsb.call();

      // commit Tx
      ((ImplementsSessionSynchronizationBMTRemoteBusiness)sfsb).commitTx();

      // Check callbacks have been made exactly once
      this.assertCallsExpected(1);  

      // Reset
      sfsb.resetCounters();

      // Check callbacks are reset
      this.assertCallbacksReset();
   }

   // --------------------------------------------------------------------------------||
   // Helper Methods -----------------------------------------------------------------||
   // --------------------------------------------------------------------------------||

   /**
    * Ensures that all SessionSynchronization callbacks are reset to 0
    */
   protected void assertCallbacksReset()
   {
      int expectedCalls = 0;
      this.assertCallsExpected(expectedCalls);
   }

   /**
    * Ensures that all SessionSynchronization callbacks have been
    * made the specified number of times
    * 
    * @param numCalls
    */
   protected void assertCallsExpected(int numCalls)
   {
      TestCase.assertEquals(numCalls, sfsb.getCounterAfterBegin());
      TestCase.assertEquals(numCalls, sfsb.getCounterAfterCompletion());
      TestCase.assertEquals(numCalls, sfsb.getCounterBeforeCompletion());
      log.info("All " + SessionSynchronization.class.getSimpleName() + " callbacks were obtained expected " + numCalls
            + " times.");
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(ImplementsSessionSynchronizationUnitTestCase.class, "jbpapp2290.jar");
   }

}
