/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.auth;

import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import org.jboss.logging.Logger;
import org.jboss.security.plugins.JaasSecurityManagerService;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;

public class AuthenticationCacheFlushThread extends Thread
{
   private static Logger log = Logger.getLogger(AuthenticationCacheFlushThread.class);
   
   private static ConcurrentReaderHashMap securityMgrMap;
   
   public AuthenticationCacheFlushThread(ConcurrentReaderHashMap securityMgrMap)
   {
      super("AuthenticationCacheFlushThread");
      this.securityMgrMap = securityMgrMap;
   }
   
   public void run()
   {
      if (log.isDebugEnabled())
         log.debug("Starting authentication cache flush thread");
      while (true)
      {
         if (log.isTraceEnabled())
            log.trace("Running authentication cache flush thread");
         // scan all security domains
         for (Iterator iterator = securityMgrMap.entrySet().iterator(); iterator.hasNext();)
         {
            Entry entry = (Entry) iterator.next();
            String securityDomain = (String) entry.getKey();
            SecurityDomainContext securityDomainCtx = (SecurityDomainContext) entry.getValue();
            CachePolicy cache = securityDomainCtx.getAuthenticationCache();
            AuthenticationTimedCachePolicy timedCache = null;
            if (cache instanceof TimedCachePolicy)
            {
               timedCache = (AuthenticationTimedCachePolicy) cache;
            }
            if (timedCache != null)
            {
               if (log.isDebugEnabled())
                  log.debug("Scanning security domain " + securityDomain + " for expired entries");
               List expiredEntries = timedCache.getInvalidKeys();
               if (log.isTraceEnabled())
                  log.trace("Found " + expiredEntries.size() + " expired entries");
               for (Iterator iterator2 = expiredEntries.iterator(); iterator2.hasNext();)
               {
                  Object expiredEntry = iterator2.next();
                  timedCache.remove(expiredEntry);
               }
            }
         }
         try
         {
            if (this.isInterrupted() == false)
               Thread.sleep(JaasSecurityManagerService.getAuthCacheFlushPeriod() * 1000);
            else
               break;
         }
         catch (InterruptedException ie)
         {
            break;
         }
      }
      if (log.isDebugEnabled())
         log.debug("Stopping authentication cache flush thread");
   }
}
