package org.jboss.seam.util;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;

import org.jboss.seam.jsf.SeamExpressionFactory;
import org.jboss.seam.util.EL;

public class UnifiedELValueBinding extends ValueBinding
{
   private ValueExpression ve;
   private ELContext elContext;

   public UnifiedELValueBinding(String expression)
   {
      elContext = EL.createELContext();
      ve = SeamExpressionFactory.INSTANCE.createValueExpression(elContext, expression, Object.class);
   }

   @Override
   public String getExpressionString()
   {
      return ve.getExpressionString();
   }

   @Override
   public Class getType(FacesContext ctx) throws EvaluationException, PropertyNotFoundException {
      return ve.getType(elContext);
   }

   @Override
   public Object getValue(FacesContext ctx) throws EvaluationException, PropertyNotFoundException {
   	return ve.getValue(elContext);
   }

   @Override
   public boolean isReadOnly(FacesContext ctx) throws EvaluationException, PropertyNotFoundException {
   	return ve.isReadOnly(elContext);
   }

   @Override
   public void setValue(FacesContext ctx, Object value) throws EvaluationException, PropertyNotFoundException {
      ve.setValue(elContext, value);
   }
   
   @Override
   public String toString()
   {
      return ve.getExpressionString();
   }
}
