/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMResponseWriter;
import com.icesoft.faces.context.RedirectException;
import com.icesoft.faces.context.SessionMap;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import com.icesoft.faces.webapp.xmlhttp.ResponseStateManager;
import com.icesoft.faces.webapp.xmlhttp.SessionExpiredException;
import com.icesoft.faces.webapp.xmlhttp.SessionLifetimeManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingServlet
extends HttpServlet {
    private static final String CHARSET = "UTF-8";
    public static final String DEBUG_DOMUPDATE = "com.icesoft.faces.debugDOMUpdate";
    public static final String STANDARD_REQUEST_SCOPE = "com.icesoft.faces.standardRequestScope";
    public static boolean standardRequestScope = false;
    static boolean debugDOMUpdate = false;
    private ResponseStateManager stateManager;
    private static String postBackKey;
    private static final Log log;
    private static final Log domLog;

    public void init(ServletConfig config) {
        this.stateManager = ResponseStateManager.getResponseStateManager(config.getServletContext());
        ServletContext servletContext = config.getServletContext();
        debugDOMUpdate = "true".equalsIgnoreCase(servletContext.getInitParameter(DEBUG_DOMUPDATE));
        standardRequestScope = "true".equalsIgnoreCase(servletContext.getInitParameter(STANDARD_REQUEST_SCOPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block29: {
            String viewNumber;
            String[] viewNumbers;
            HttpSession session;
            block28: {
                session = request.getSession(false);
                if (session == null) {
                    this.respondSessionExpired(response);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("request.pathInfo " + request.getPathInfo()));
                    Iterator keys = request.getParameterMap().keySet().iterator();
                    while (keys.hasNext()) {
                        Object key = keys.next();
                        log.debug((Object)("request." + key + " = " + ((String[])request.getParameterMap().get(key))[0]));
                    }
                }
                viewNumbers = null;
                viewNumber = request.getParameter("viewNumber");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("service(-)  viewNumber: " + viewNumber));
                }
                try {
                    if (null != viewNumber) {
                        viewNumbers = viewNumber.split(",");
                        viewNumber = viewNumbers[0];
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("service(-)  viewNumbers.length: " + viewNumbers.length));
                            for (int i = 0; i < viewNumbers.length; ++i) {
                                log.trace((Object)("service(-)  viewNumbers[" + i + "]: " + viewNumbers[i]));
                            }
                        }
                    }
                    Integer.parseInt(viewNumber);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"service(-)  PARSED");
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Could not parse viewNumber " + viewNumber + ": " + e.getMessage()));
                    }
                    viewNumber = (String)session.getAttribute("com.icesoft.faces.currentViewNumber");
                    viewNumbers = new String[]{viewNumber};
                    if (!log.isTraceEnabled()) break block28;
                    log.trace((Object)("service(-)  RECOVERED  viewNumber: " + viewNumber));
                }
            }
            BridgeExternalContext bridgeExternalContext = null;
            try {
                ResponseState state = null;
                Object PFstate = null;
                state = this.stateManager.getState(session, viewNumber);
                Object eventLock = state.getEventLock();
                String method = request.getPathInfo();
                if ("/send-updates".equals(method) || "/receive-send-updates".equals(method)) {
                    Object object = eventLock;
                    synchronized (object) {
                        this.executeRequest(request, response, state, viewNumbers);
                        break block29;
                    }
                }
                this.executeRequest(request, response, state, viewNumbers);
            }
            catch (RedirectException re) {
                if (bridgeExternalContext != null) {
                    String url = bridgeExternalContext.redirectTo();
                    response.setHeader("X-REDIRECT", url);
                    response.getOutputStream().write(46);
                    response.getOutputStream().write(10);
                    response.flushBuffer();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Redirect SENT -> RedirectException: " + url));
                    }
                }
            }
            catch (SessionExpiredException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("User session expired. ViewNumber = [" + viewNumber + "]"), (Throwable)e);
                }
                this.respondSessionExpired(response);
            }
            catch (IllegalAccessException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new ServletException((Throwable)e);
            }
            finally {
                PersistentFacesState.clearLocalInstance();
            }
        }
    }

    private void executeRequest(HttpServletRequest request, HttpServletResponse response, ResponseState state, String[] viewNumbers) throws IOException, IllegalAccessException {
        String viewNumber = viewNumbers[0];
        HttpSession session = request.getSession(false);
        SessionMap sessionMap = new SessionMap(session);
        BridgeExternalContext bridgeExternalContext = null;
        PersistentFacesState PFstate = PersistentFacesState.getInstance(sessionMap, viewNumber);
        PersistentFacesState.setLocalInstance(sessionMap, viewNumber);
        if (PFstate.facesContext instanceof BridgeFacesContext) {
            BridgeFacesContext facesContext = (BridgeFacesContext)PFstate.facesContext;
            facesContext.setCurrentInstance();
            bridgeExternalContext = (BridgeExternalContext)facesContext.getExternalContext();
            if (standardRequestScope) {
                bridgeExternalContext.clearRequestMap();
            }
            bridgeExternalContext.clearRequestContext();
            Map map = request.getParameterMap();
            bridgeExternalContext.populateRequestParameters(BlockingServlet.convertParametersMap(map));
            String[] cssUpdates = request.getParameterValues(CurrentStyle.CSS_UPDATE_FIELD);
            if (cssUpdates == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"service(-)  No CSS update");
                }
            } else {
                for (int i = 0; i < cssUpdates.length; ++i) {
                    String cssUpdate = cssUpdates[i];
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("service(-)  cssUpdate: " + cssUpdate));
                    }
                    try {
                        CurrentStyle.decode(request, cssUpdate);
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Unable to parse CSS update [" + cssUpdate + "]"), (Throwable)e);
                    }
                }
            }
            state.setFocusID(request.getParameter("focus"));
            String method = request.getPathInfo();
            if ("/receive-updates".startsWith(method)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"service(-)  receive-updates");
                }
                state.block(request);
                this.applyCookies(bridgeExternalContext, response);
                if (!state.hasHandler()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"service(-)    !state.hasHandler()");
                    }
                    if (this.applyRedirect(session, response, viewNumber)) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"service(-)    applyRedirect -> state.cancel");
                        }
                        state.cancel();
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"service(-)    sendAllUpdates");
                        }
                        this.sendAllUpdates(session, response, viewNumbers);
                    }
                }
            } else if ("/send-updates".equals(method)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"service(-)  send-updates");
                }
                SessionLifetimeManager.touch(session);
                this.receiveUpdates(request, facesContext, state);
                this.applyCookies(bridgeExternalContext, response);
                if (this.applyRedirect(session, response, viewNumber)) {
                    state.cancel();
                }
            } else if ("/receive-send-updates".equals(method)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"service(-)  receive-send-updates");
                }
                SessionLifetimeManager.touch(session);
                this.receiveUpdates(request, facesContext, state);
                this.applyCookies(bridgeExternalContext, response);
                if (this.applyRedirect(session, response, viewNumber)) {
                    state.cancel();
                } else {
                    this.sendAllUpdates(session, response, viewNumbers);
                }
            } else if ("/ping".equals(method)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"service(-)  ping");
                }
                state.flush();
                response.setContentLength(0);
                if (!response.isCommitted()) {
                    response.flushBuffer();
                }
            } else {
                SessionLifetimeManager.touch(session);
                throw new IllegalAccessException("Unknown request type: '" + method + "'.");
            }
        }
    }

    private void respondSessionExpired(HttpServletResponse response) throws IOException {
        response.setHeader("X-SESSION-EXPIRED", ".");
        response.getOutputStream().write(46);
        response.getOutputStream().write(10);
        response.flushBuffer();
    }

    private void sendAllUpdates(HttpSession session, HttpServletResponse response, String[] viewNumbers) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"sendAllUpdates(-)  BEGIN");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, CHARSET);
        writer.write("<updates>");
        if (log.isTraceEnabled()) {
            log.trace((Object)("sendAllUpdates(-)    viewNumbers.length: " + viewNumbers.length));
        }
        for (int i = 0; i < viewNumbers.length; ++i) {
            ResponseState responseState = this.stateManager.getState(session, viewNumbers[i]);
            if (log.isTraceEnabled()) {
                log.trace((Object)("sendAllUpdates(-)    viewNumbers[" + i + "]: " + viewNumbers[i] + ", session: " + session + ", responseState: " + responseState));
            }
            responseState.serialize(writer);
        }
        writer.write("</updates>\n");
        ((Writer)writer).flush();
        if (domLog.isDebugEnabled()) {
            domLog.debug((Object)("Update\n" + out));
        }
        byte[] content = out.toByteArray();
        response.setContentType("text/xml;charset=UTF-8");
        response.setContentLength(content.length);
        response.getOutputStream().write(content);
        response.flushBuffer();
        if (log.isTraceEnabled()) {
            log.trace((Object)"sendAllUpdates(-)  DONE");
        }
    }

    public static Map convertParametersMap(Map parameters) {
        HashMap convertedParameters = new HashMap(parameters);
        Iterator iterator = convertedParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String[] values = (String[])entry.getValue();
            if (values.length > 1) {
                entry.setValue(Arrays.asList(values));
                continue;
            }
            if (values.length != 1) continue;
            entry.setValue(values[0]);
        }
        return convertedParameters;
    }

    private void receiveUpdates(HttpServletRequest request, BridgeFacesContext context, ResponseState state) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        if ("true".equals(request.getParameter("partial"))) {
            String componentID = request.getParameter("ice.event.captured");
            UIComponent component = D2DViewHandler.findComponent(componentID, (UIComponent)context.getViewRoot());
            this.renderCyclePartial(context, lifecycle, component);
        } else {
            this.renderCycle(context, lifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderCycle(BridgeFacesContext context, Lifecycle lifecycle) {
        BridgeFacesContext bridgeFacesContext = context;
        synchronized (bridgeFacesContext) {
            context.setCurrentInstance();
            DOMResponseWriter.applyBrowserDOMChanges(context);
            if (null != postBackKey) {
                context.getExternalContext().getRequestParameterMap().put(postBackKey, "not reload");
            }
            lifecycle.execute((FacesContext)context);
            lifecycle.render((FacesContext)context);
            context.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderCyclePartial(BridgeFacesContext context, Lifecycle lifecycle, UIComponent component) {
        BridgeFacesContext bridgeFacesContext = context;
        synchronized (bridgeFacesContext) {
            context.setCurrentInstance();
            DOMResponseWriter.applyBrowserDOMChanges(context);
            List alteredRequiredComponents = this.setRequiredFalseInFormContaining(component);
            if (null != postBackKey) {
                context.getExternalContext().getRequestParameterMap().put(postBackKey, "not reload");
            }
            lifecycle.execute((FacesContext)context);
            lifecycle.render((FacesContext)context);
            context.release();
            this.setRequiredTrue(alteredRequiredComponents);
        }
    }

    private void applyCookies(BridgeExternalContext bridgeContext, HttpServletResponse response) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"applyCookies()");
        }
        Map cookieMap = bridgeContext.getResponseCookieMap();
        Iterator cookieNames = cookieMap.keySet().iterator();
        while (cookieNames.hasNext()) {
            response.addCookie((Cookie)cookieMap.get(cookieNames.next()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyRedirect(HttpSession session, HttpServletResponse response, String viewNumber) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("applyRedirect()  viewNumber: " + viewNumber + "  session: " + session + "  response: " + response));
        }
        boolean isRedirect = false;
        try {
            PersistentFacesState PFstate = PersistentFacesState.getInstance(new SessionMap(session), viewNumber);
            FacesContext context = PFstate.facesContext;
            if (log.isTraceEnabled()) {
                log.trace((Object)("applyRedirect()  session: " + session + "  PFstate: " + PFstate + "  context: " + context));
            }
            if (context instanceof BridgeFacesContext) {
                BridgeExternalContext externalContext;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"applyRedirect()  BridgeFacesContext");
                }
                if ((externalContext = (BridgeExternalContext)context.getExternalContext()).redirectRequested()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("applyRedirect()  REDIRECT " + externalContext.redirectTo()));
                    }
                    isRedirect = true;
                    response.setHeader("X-REDIRECT", externalContext.redirectTo());
                    response.getOutputStream().write(46);
                    externalContext.redirectComplete();
                }
            }
        }
        finally {
            return isRedirect;
        }
    }

    private void setRequiredTrue(List requiredComponents) {
        Iterator i = requiredComponents.iterator();
        UIInput next = null;
        while (i.hasNext()) {
            next = (UIInput)i.next();
            next.setRequired(true);
        }
    }

    private List setRequiredFalseInFormContaining(UIComponent component) {
        ArrayList alteredComponents = new ArrayList();
        UIComponent form = this.getContainingForm(component);
        this.setRequiredFalseOnAllChildrenExceptOne(form, component, alteredComponents);
        return alteredComponents;
    }

    private void setRequiredFalseOnAllChildrenExceptOne(UIComponent parent, UIComponent componentToAvoid, List alteredComponents) {
        int length = parent.getChildCount();
        UIComponent next = null;
        for (int i = 0; i < length; ++i) {
            next = (UIComponent)parent.getChildren().get(i);
            if (next instanceof UIInput && next != componentToAvoid && ((UIInput)next).isRequired()) {
                ((UIInput)next).setRequired(false);
                alteredComponents.add(next);
            }
            this.setRequiredFalseOnAllChildrenExceptOne(next, componentToAvoid, alteredComponents);
        }
    }

    private UIComponent getContainingForm(UIComponent component) {
        UIComponent parent;
        if (null == component) {
            return FacesContext.getCurrentInstance().getViewRoot();
        }
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    public void destroy() {
    }

    static {
        log = LogFactory.getLog((Class)BlockingServlet.class);
        domLog = LogFactory.getLog((String)"blocking.dom.update");
        try {
            Field field = javax.faces.render.ResponseStateManager.class.getField("VIEW_STATE_PARAM");
            if (null != field) {
                postBackKey = (String)field.get(javax.faces.render.ResponseStateManager.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

