/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.management;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.common.management.AbstractServerConfigMBean;
import org.jboss.wsf.spi.management.ServerConfig;

public abstract class AbstractServerConfig
implements AbstractServerConfigMBean,
ServerConfig {
    private static final Logger log = Logger.getLogger(AbstractServerConfig.class);
    private MBeanServer mbeanServer;
    private String webServiceHost = "jbossws.undefined.host";
    private int webServicePort;
    private int webServiceSecurePort;
    private boolean modifySOAPAddress;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    public void setWebServiceHost(String string) throws UnknownHostException {
        if (string == null || string.trim().length() == 0) {
            log.debug((Object)"Using undefined host: jbossws.undefined.host");
            string = "jbossws.undefined.host";
        }
        if ("0.0.0.0".equals(string)) {
            InetAddress inetAddress = InetAddress.getLocalHost();
            log.debug((Object)("Using local host: " + inetAddress.getHostName()));
            string = inetAddress.getHostName();
        }
        this.webServiceHost = string;
    }

    public void setWebServicePort(int n) {
        this.webServicePort = n;
    }

    public void setWebServiceSecurePort(int n) {
        this.webServiceSecurePort = n;
    }

    public boolean isModifySOAPAddress() {
        return this.modifySOAPAddress;
    }

    public void setModifySOAPAddress(boolean bl) {
        this.modifySOAPAddress = bl;
    }

    public File getServerTempDir() {
        try {
            ObjectName objectName = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File file = (File)this.getMbeanServer().getAttribute(objectName, "ServerTempDir");
            return file;
        }
        catch (JMException jMException) {
            return null;
        }
    }

    public File getServerDataDir() {
        try {
            ObjectName objectName = ObjectNameFactory.create("jboss.system:type=ServerConfig");
            File file = (File)this.getMbeanServer().getAttribute(objectName, "ServerDataDir");
            return file;
        }
        catch (JMException jMException) {
            return null;
        }
    }

    public int getWebServicePort() {
        int n;
        if (this.webServicePort <= 0) {
            this.webServicePort = this.getConnectorPort("HTTP/1.1", false);
        }
        if ((n = this.webServicePort) <= 0) {
            log.warn((Object)"Unable to calculate 'WebServicePort', using default '8080'");
            n = 8080;
        }
        return n;
    }

    public int getWebServiceSecurePort() {
        int n;
        if (this.webServiceSecurePort <= 0) {
            this.webServiceSecurePort = this.getConnectorPort("HTTP/1.1", true);
        }
        if ((n = this.webServiceSecurePort) <= 0) {
            log.warn((Object)"Unable to calculate 'WebServiceSecurePort', using default '8443'");
            n = 8443;
        }
        return n;
    }

    public void create() throws Exception {
        this.getMbeanServer().registerMBean(this, AbstractServerConfigMBean.OBJECT_NAME);
    }

    public void destroy() throws Exception {
        this.getMbeanServer().unregisterMBean(AbstractServerConfigMBean.OBJECT_NAME);
    }

    private int getConnectorPort(String string, boolean bl) {
        int n = -1;
        try {
            ObjectName objectName = new ObjectName("jboss.web:type=Connector,*");
            Set<ObjectName> set = this.getMbeanServer().queryNames(objectName, null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2;
                ObjectName objectName3 = objectName2 = iterator.next();
                try {
                    int n2 = (Integer)this.getMbeanServer().getAttribute(objectName3, "port");
                    boolean bl2 = (Boolean)this.getMbeanServer().getAttribute(objectName3, "secure");
                    String string2 = (String)this.getMbeanServer().getAttribute(objectName3, "protocol");
                    if (!string.equals(string2) || bl != bl2) continue;
                    if (n > -1) {
                        log.warn((Object)("Found multiple connectors for protocol='" + string + "' and secure='" + bl + "', using first port found '" + n + "'"));
                        continue;
                    }
                    n = n2;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {}
            }
            return n;
        }
        catch (JMException jMException) {
            return -1;
        }
    }
}

