/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.ComponentVariables;
import org.ajax4jsf.framework.renderer.ComponentsVariableResolver;
import org.ajax4jsf.framework.renderer.RendererBase;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.javascript.ScriptUtils;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.UITree;
import org.richfaces.component.UITreeNode;
import org.richfaces.component.events.AjaxSelectedEvent;
import org.richfaces.component.events.NodeExpandedEvent;
import org.richfaces.component.events.NodeSelectedEvent;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.events.CollapseNodeCommandEvent;
import org.richfaces.component.state.events.ExpandNodeCommandEvent;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.DraggableRendererContributor;
import org.richfaces.renderkit.DropzoneRendererContributor;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public abstract class NodeRendererBase
extends CompositeRenderer {
    static /* synthetic */ Class class$org$ajax4jsf$dnd$Draggable;
    static /* synthetic */ Class class$org$ajax4jsf$dnd$Dropzone;

    public NodeRendererBase() {
        this.addContributor(DropzoneRendererContributor.getInstance());
        this.addContributor(DraggableRendererContributor.getInstance());
        this.addParameterEncoder(DnDParametersEncoder.getInstance());
    }

    protected String getToggleScript(FacesContext context, UITreeNode treeNode) {
        UITree tree = treeNode.getUITree();
        String id = tree.getClientId(context);
        String toggleId = id + ':' + "_toggleLink";
        if ("ajax".equals(tree.getSwitchType())) {
            JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tree, (FacesContext)context);
            Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tree);
            Map parameters = (Map)eventOptions.get("parameters");
            parameters.remove(id);
            parameters.put(toggleId, toggleId);
            parameters.put(tree.getBaseClientId(context) + ":expanded", String.valueOf(tree.isExpanded()));
            if (((Boolean)treeNode.getAttributes().get("isLastElement")).booleanValue()) {
                parameters.put(tree.getBaseClientId(context) + ":lastElement", Boolean.TRUE);
            }
            function.addParameter((Object)eventOptions);
            StringBuffer buffer = new StringBuffer();
            function.appendScript(buffer);
            buffer.append(";");
            return buffer.toString();
        }
        if ("server".equals(tree.getSwitchType())) {
            StringBuffer result = new StringBuffer();
            result.append('{');
            result.append("var params = new Object();");
            result.append("params['");
            result.append(tree.getBaseClientId(context) + ":expanded");
            result.append("'] = ");
            result.append(tree.isExpanded());
            result.append(';');
            result.append("_JSFFormSubmit('");
            result.append(toggleId);
            result.append("', ");
            result.append("A4J.findForm(this).id, ");
            result.append("'', ");
            result.append("params);};");
            return result.toString();
        }
        return "";
    }

    public void initializeLines(FacesContext context, UITreeNode treeNode) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)treeNode);
        UITree tree = treeNode.getUITree();
        if (tree.isShowConnectingLines()) {
            if (((Boolean)treeNode.getAttributes().get("isLastElement")).booleanValue()) {
                variables.setVariable("line", (Object)"dr-tree-h-ic-line-last");
            } else {
                variables.setVariable("line", (Object)"dr-tree-h-ic-line-node");
            }
            if (tree.isExpanded()) {
                variables.setVariable("lineFirst", (Object)"dr-tree-h-ic-line-exp");
            } else {
                variables.setVariable("lineFirst", (Object)"dr-tree-h-ic-line-clp");
            }
        }
    }

    public void initializeResources(FacesContext context, UITreeNode treeNode) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)treeNode);
        UITree tree = treeNode.getUITree();
        String resource = "dr-tree-i-hl";
        resource = resource + " rich-tree-node-highlighted";
        String cssClass = tree.getHighlightedClass();
        if (cssClass != null) {
            resource = resource + " " + cssClass;
        }
        if ((cssClass = treeNode.getHighlightedClass()) != null) {
            resource = resource + " " + cssClass;
        }
        variables.setVariable("highlightedClass", (Object)resource);
        resource = "dr-tree-i-sel";
        resource = resource + " rich-tree-node-selected";
        cssClass = tree.getSelectedClass();
        if (cssClass != null) {
            resource = resource + " " + cssClass;
        }
        if ((cssClass = treeNode.getSelectedClass()) != null) {
            resource = resource + " " + cssClass;
        }
        variables.setVariable("selectedClass", (Object)resource);
        resource = ViewUtil.getResourceURL(treeNode.getIcon());
        if (resource == null) {
            resource = ViewUtil.getResourceURL(tree.getIcon());
        }
        if (resource != null) {
            variables.setVariable("folder", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL(treeNode.getIconCollapsed())) == null) {
            resource = ViewUtil.getResourceURL(tree.getIconCollapsed());
        }
        if (resource != null) {
            variables.setVariable("collapsed", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL(treeNode.getIconExpanded())) == null) {
            resource = ViewUtil.getResourceURL(tree.getIconExpanded());
        }
        if (resource != null) {
            variables.setVariable("expanded", (Object)resource);
        }
        if ((resource = ViewUtil.getResourceURL(treeNode.getIconLeaf())) == null) {
            resource = ViewUtil.getResourceURL(tree.getIconLeaf());
        }
        if (resource != null) {
            variables.setVariable("leaf", (Object)resource);
        }
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UITreeNode node = (UITreeNode)component;
        UITree tree = node.getUITree();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String id = tree.getClientId(context);
        TreeState componentState = (TreeState)tree.getComponentState();
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        String toggleId = id + ':' + "_toggleLink";
        if (requestMap.containsKey(toggleId) || toggleId.equals(tree.getAttributes().get("_toggleLink"))) {
            if (((Boolean)tree.getAttributes().get(":expanded")).booleanValue()) {
                new CollapseNodeCommandEvent((UIComponent)tree, key).queue();
            } else {
                new ExpandNodeCommandEvent((UIComponent)tree, key).queue();
            }
            new NodeExpandedEvent((UIComponent)node).queue();
            new NodeExpandedEvent((UIComponent)tree).queue();
            if (AjaxRendererUtils.isAjaxRequest((FacesContext)context)) {
                HashSet<TreeRowKey> ajaxKeys = tree.getAjaxKeys();
                if (ajaxKeys == null) {
                    ajaxKeys = new HashSet<TreeRowKey>();
                    tree.setAjaxKeys(ajaxKeys);
                }
                ajaxKeys.add(key);
            }
        }
        if (id.equals(tree.getAttributes().get("_selectionInput"))) {
            if (componentState.setSelected(key)) {
                if (tree.getAttributes().get(":selectedNode") == null) {
                    new NodeSelectedEvent((UIComponent)node).queue();
                    new NodeSelectedEvent((UIComponent)tree).queue();
                } else {
                    new AjaxSelectedEvent((UIComponent)node).queue();
                    new AjaxSelectedEvent((UIComponent)tree).queue();
                }
            }
            tree.getAttributes().remove("_selectionInput");
        }
    }

    public String getAjaxSelectedListenerFlag(FacesContext context, UITreeNode treeNode) throws IOException {
        if (treeNode.hasAjaxSubmitSelection()) {
            return "ajax_selected_listener_flag";
        }
        return null;
    }

    public String getParentClientId(FacesContext context, UITreeNode treeNode) throws IOException {
        return treeNode.getUITree().getClientId(context);
    }

    public String getDraggableScriptOptions(FacesContext context, UITreeNode component) {
        TreeNodeOptions options = new TreeNodeOptions((UIComponent)component);
        this.mergeScriptOptions(options, context, (UIComponent)component, class$org$ajax4jsf$dnd$Draggable == null ? (class$org$ajax4jsf$dnd$Draggable = NodeRendererBase.class$("org.ajax4jsf.dnd.Draggable")) : class$org$ajax4jsf$dnd$Draggable);
        return ScriptUtils.toScript((Object)((Object)options));
    }

    public String getDropzoneScriptOptions(FacesContext context, UITreeNode component) {
        TreeNodeOptions options = new TreeNodeOptions((UIComponent)component);
        this.mergeScriptOptions(options, context, (UIComponent)component, class$org$ajax4jsf$dnd$Dropzone == null ? (class$org$ajax4jsf$dnd$Dropzone = NodeRendererBase.class$("org.ajax4jsf.dnd.Dropzone")) : class$org$ajax4jsf$dnd$Dropzone);
        return ScriptUtils.toScript((Object)((Object)options));
    }

    public void contributorDecodeCallback(UIComponent component, FacesContext context, RendererContributor contributor, Object argument) {
        super.contributorDecodeCallback(component, context, contributor, argument);
        if ((class$org$ajax4jsf$dnd$Draggable == null ? (class$org$ajax4jsf$dnd$Draggable = NodeRendererBase.class$("org.ajax4jsf.dnd.Draggable")) : class$org$ajax4jsf$dnd$Draggable).isAssignableFrom(contributor.getAcceptableClass())) {
            UITreeNode treeNode = (UITreeNode)component;
            treeNode.setDragValue(treeNode.getUITree().getRowKey());
        } else if ((class$org$ajax4jsf$dnd$Dropzone == null ? (class$org$ajax4jsf$dnd$Dropzone = NodeRendererBase.class$("org.ajax4jsf.dnd.Dropzone")) : class$org$ajax4jsf$dnd$Dropzone).isAssignableFrom(contributor.getAcceptableClass())) {
            UITreeNode treeNode = (UITreeNode)component;
            treeNode.setDropValue(treeNode.getUITree().getRowKey());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TreeNodeOptions
    extends ScriptOptions {
        public TreeNodeOptions(UIComponent component) {
            super(component);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            if (((Boolean)component.getAttributes().get("isLastElement")).booleanValue()) {
                UITree tree = ((UITreeNode)component).getUITree();
                params.put(tree.getBaseClientId(FacesContext.getCurrentInstance()) + ":lastElement", Boolean.TRUE);
            }
            this.addOption("parameters", params);
        }
    }
}

