/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.GifRenderer;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.Java2Dresource;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceRenderer;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.HtmlColor;
import org.ajax4jsf.framework.util.HtmlDimensions;

public class BaseGradient
extends Java2Dresource {
    private int width;
    private int height;
    private int gradientHeight;
    private String baseColor;
    private String gradientColor;

    public BaseGradient(int width, int height, int gradientHeight) {
        this.width = width;
        this.height = height;
        this.gradientHeight = gradientHeight;
        this.setRenderer((ResourceRenderer)new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        this(width, height, gradientHeight);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient(int width, int height) {
        this(width, height, height);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor) {
        this(width, height, height);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient() {
        this(30, 50, 20);
    }

    public BaseGradient(String baseColor, String gradientColor) {
        this(30, 50, 20);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return new Dimension(this.width, this.height);
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimensions(null, this.restoreData(resourceContext));
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        Data dataToStore = (Data)resourceContext.getResourceData();
        if (dataToStore.headerBackgroundColor != null && dataToStore.headerGradientColor != null) {
            Color baseColor = new Color(dataToStore.headerBackgroundColor);
            Dimension dim = this.getDimensions(resourceContext);
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
            boolean gradStart = false;
            int gradEnd = this.gradientHeight;
            Color alternateColor = new Color(dataToStore.headerGradientColor);
            GradientPaint gragient = new GradientPaint(0.0f, (float)gradStart, baseColor, 0.0f, gradEnd, alternateColor);
            g2d.setPaint(gragient);
            g2d.fill(rect);
        }
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        if (this.baseColor == null) {
            return new Data(context, data);
        }
        return new Data(context, data, this.baseColor, this.gradientColor);
    }

    public boolean isCacheable() {
        return true;
    }

    protected static class Data
    implements Serializable {
        private static final long serialVersionUID = 1732700513743861250L;
        protected Integer headerBackgroundColor;
        protected Integer headerGradientColor;

        public Data() {
        }

        protected Data(FacesContext context, Object data) {
            this.headerBackgroundColor = this.getColorValueParameter(context, data, "headerBackgroundColor");
            this.headerGradientColor = this.getColorValueParameter(context, data, "headerGradientColor");
        }

        protected Data(FacesContext context, Object data, String baseColor, String gradientColor) {
            this.headerBackgroundColor = this.getColorValueParameter(context, data, baseColor);
            this.headerGradientColor = this.getColorValueParameter(context, data, gradientColor);
        }

        private Integer getColorValueParameter(FacesContext context, Object data, String name) {
            Skin skin = SkinFactory.getInstance().getSkin(context);
            String tmp = (String)skin.getParameter(context, name);
            if (tmp != null) {
                return new Integer(HtmlColor.decode((String)tmp).getRGB());
            }
            return null;
        }

        private Integer getDimensionValueParameter(FacesContext context, Object data, String name) {
            Skin skin = SkinFactory.getInstance().getSkin(context);
            String tmp = (String)skin.getParameter(context, name);
            if (tmp != null) {
                return new Integer(HtmlDimensions.decode((String)tmp).intValue());
            }
            return null;
        }

        private Integer getIntegerValueParameter(FacesContext context, Object data, String name) {
            Skin skin = SkinFactory.getInstance().getSkin(context);
            String tmp = (String)skin.getParameter(context, name);
            if (tmp != null) {
                return new Integer(tmp);
            }
            return null;
        }
    }
}

