/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.Constructor;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SecuritySPIActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextFactory {
    private static String defaultFQN = "org.jboss.security.plugins.JBossSecurityContext";
    private static String defaultUtilClassFQN = "org.jboss.security.plugins.JBossSecurityContextUtil";
    private static Class<? extends SecurityContext> defaultSecurityContextClass = null;
    private static Class<? extends SecurityContextUtil> defaultUtilClass = null;

    public static SecurityContext createSecurityContext(String securityDomain) throws Exception {
        if (defaultSecurityContextClass != null) {
            return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextClass);
        }
        return SecurityContextFactory.createSecurityContext(securityDomain, defaultFQN);
    }

    public static SecurityContext createSecurityContext(String securityDomain, String fqnClass) throws Exception {
        if (securityDomain == null) {
            throw new IllegalArgumentException("securityDomain is null");
        }
        if (fqnClass == null) {
            throw new IllegalArgumentException("fqnClass is null");
        }
        defaultSecurityContextClass = SecurityContextFactory.getContextClass(fqnClass);
        return SecurityContextFactory.createSecurityContext(securityDomain, defaultSecurityContextClass);
    }

    public static SecurityContext createSecurityContext(String securityDomain, Class<? extends SecurityContext> clazz) throws Exception {
        if (securityDomain == null) {
            throw new IllegalArgumentException("securityDomain is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        Constructor<? extends SecurityContext> ctr = clazz.getConstructor(String.class);
        return ctr.newInstance(securityDomain);
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain) throws Exception {
        SecurityContext jsc = SecurityContextFactory.createSecurityContext(securityDomain);
        jsc.getUtil().createSubjectInfo(p, cred, s);
        return jsc;
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain, String fqnClass) throws Exception {
        SecurityContext sc = SecurityContextFactory.createSecurityContext(securityDomain, fqnClass);
        sc.getUtil().createSubjectInfo(p, cred, s);
        return sc;
    }

    public static SecurityContextUtil createUtil(SecurityContext sc) throws Exception {
        Class<SecurityContextUtil> clazz = defaultUtilClass;
        if (clazz == null) {
            defaultUtilClass = clazz = SecurityContextFactory.loadClass(defaultUtilClassFQN);
        }
        Constructor<? extends SecurityContextUtil> ctr = clazz.getConstructor(SecurityContext.class);
        SecurityContextUtil obj = ctr.newInstance(sc);
        return (SecurityContextUtil)SecurityContextUtil.class.cast(obj);
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, String utilFQN) throws Exception {
        ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
        Class<?> clazz = tcl.loadClass(utilFQN);
        Constructor<?> ctr = clazz.getConstructor(SecurityContext.class);
        return (SecurityContextUtil)ctr.newInstance(sc);
    }

    public static SecurityContextUtil createUtil(SecurityContext sc, Class<? extends SecurityContextUtil> utilClazz) throws Exception {
        Constructor<? extends SecurityContextUtil> ctr = utilClazz.getConstructor(SecurityContext.class);
        return ctr.newInstance(sc);
    }

    public static void setDefaultSecurityContextFQN(String fqn) {
        defaultFQN = fqn;
        defaultSecurityContextClass = null;
    }

    public static void setDefaultSecurityContextUtilFQN(String fqn) {
        defaultUtilClassFQN = fqn;
        defaultUtilClass = null;
    }

    private static Class<?> loadClass(String fqn) throws Exception {
        ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
        return tcl.loadClass(fqn);
    }

    private static Class<SecurityContext> getContextClass(String className) throws Exception {
        ClassLoader tcl = SecuritySPIActions.getContextClassLoader();
        return tcl.loadClass(className);
    }

    static {
        try {
            defaultSecurityContextClass = SecuritySPIActions.getContextClassLoader().loadClass(defaultFQN);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            defaultUtilClass = SecuritySPIActions.getContextClassLoader().loadClass(defaultUtilClassFQN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

