/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.zip.CertificateReaderInputStream;
import org.jboss.virtual.plugins.context.zip.EntryInfoAdapter;
import org.jboss.virtual.plugins.context.zip.ZipFileLockReaper;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipFileWrapper
extends ZipWrapper {
    private static final Logger log = Logger.getLogger(ZipFileWrapper.class);
    private static boolean forceNoReaper = AccessController.doPrivileged(new CheckNoReaper());
    private File file;
    private ZipFile zipFile;
    private boolean autoClean;
    private boolean noReaperOverride;

    ZipFileWrapper(File archive, boolean autoClean, boolean noReaperOverride) {
        this.noReaperOverride = noReaperOverride;
        this.init(archive, autoClean);
    }

    ZipFileWrapper(URI rootPathURI, boolean autoClean, boolean noReaperOverride) {
        this.noReaperOverride = noReaperOverride;
        File rootFile = new File(rootPathURI);
        if (!rootFile.isFile()) {
            throw new RuntimeException("File not found: " + rootFile);
        }
        this.init(rootFile, autoClean);
    }

    private void init(File archive, boolean autoClean) {
        this.file = archive;
        this.lastModified = this.file.lastModified();
        this.autoClean = autoClean;
        if (autoClean) {
            this.file.deleteOnExit();
        }
    }

    @Override
    boolean exists() {
        return this.file.isFile();
    }

    @Override
    long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    String getName() {
        return this.file.getName();
    }

    @Override
    long getSize() {
        return this.file.length();
    }

    private ZipFile ensureZipFile() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new JarFile(this.file);
            if (!forceNoReaper && !this.noReaperOverride) {
                ZipFileLockReaper.getInstance().register(this);
            }
        }
        return this.zipFile;
    }

    synchronized void closeZipFile() throws IOException {
        if (this.zipFile != null && this.getReferenceCount() <= 0) {
            ZipFile zf = this.zipFile;
            this.zipFile = null;
            zf.close();
            if (!forceNoReaper && !this.noReaperOverride) {
                ZipFileLockReaper.getInstance().unregister(this);
            }
        }
    }

    @Override
    synchronized InputStream openStream(ZipEntry entry) throws IOException {
        if (entry.isDirectory()) {
            return this.recomposeZipAsInputStream(entry.getName());
        }
        this.ensureZipFile();
        ZipEntry update = this.zipFile.getEntry(entry.getName());
        InputStream is = this.zipFile.getInputStream(update);
        if (is == null) {
            throw new IOException("Entry no longer available: " + entry.getName() + " in file " + this.file);
        }
        if (entry instanceof EntryInfoAdapter) {
            ((EntryInfoAdapter)EntryInfoAdapter.class.cast(entry)).updateEntry(update);
        }
        CertificateReaderInputStream zis = new CertificateReaderInputStream(entry, this, is);
        this.incrementRef();
        return zis;
    }

    @Override
    InputStream getRootAsStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    synchronized void acquire() throws IOException {
        this.ensureZipFile();
        this.incrementRef();
    }

    @Override
    synchronized void release() {
        super.release();
        if (forceNoReaper || this.noReaperOverride) {
            try {
                this.closeZipFile();
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to release file: " + this.file));
            }
        }
    }

    @Override
    synchronized Enumeration<? extends ZipEntry> entries() throws IOException {
        return this.ensureZipFile().entries();
    }

    @Override
    void close() {
        try {
            this.closeZipFile();
        }
        catch (Exception ignored) {
            log.warn((Object)("IGNORING: Failed to release file: " + this.file), (Throwable)ignored);
        }
        if (this.autoClean) {
            ZipFileWrapper.traceDelete(this.file);
        }
    }

    void deleteFile(ZipFileWrapper wrapper) throws IOException {
        if (this.file.equals(wrapper.file)) {
            this.closeZipFile();
            ZipFileWrapper.traceDelete(this.file);
        }
    }

    private static void traceDelete(File ref) {
        if (!ref.delete() && log.isTraceEnabled()) {
            log.trace((Object)("Failed to delete file: " + ref));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean delete(int gracePeriod) throws IOException {
        boolean exists = this.file.isFile();
        if (!exists) {
            return false;
        }
        boolean interrupted = Thread.interrupted();
        try {
            long endOfGrace = System.currentTimeMillis() + (long)gracePeriod;
            do {
                this.closeZipFile();
                ZipFileLockReaper.getInstance().deleteFile(this);
                try {
                    if (!this.file.exists() || this.file.delete()) {
                        boolean bl = true;
                        return bl;
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    boolean bl = !this.file.exists() || this.file.delete();
                    return bl;
                }
            } while (System.currentTimeMillis() < endOfGrace);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return this.file.delete();
    }

    @Override
    protected synchronized void recomposeZip(OutputStream baos, String path) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(baos);
        zout.setMethod(0);
        this.ensureZipFile();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            String newName;
            ZipEntry oldEntry = entries.nextElement();
            if (!oldEntry.getName().startsWith(path) || (newName = oldEntry.getName().substring(path.length())).length() == 0) continue;
            ZipEntry newEntry = new ZipEntry(newName);
            newEntry.setComment(oldEntry.getComment());
            newEntry.setTime(oldEntry.getTime());
            newEntry.setSize(oldEntry.getSize());
            newEntry.setCrc(oldEntry.getCrc());
            zout.putNextEntry(newEntry);
            if (oldEntry.isDirectory()) continue;
            VFSUtils.copyStream(this.zipFile.getInputStream(oldEntry), zout);
        }
        zout.close();
    }

    public String toString() {
        return super.toString() + " - " + this.file.getAbsolutePath();
    }

    static {
        if (forceNoReaper) {
            log.info((Object)"VFS forced no-reaper-mode is enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckNoReaper
    implements PrivilegedAction<Boolean> {
        private CheckNoReaper() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceNoReaper", "false");
            return Boolean.valueOf(forceString);
        }
    }
}

