/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import org.jgroups.Message;

public class Event {
    public static final int MSG = 1;
    public static final int CONNECT = 2;
    public static final int DISCONNECT = 4;
    public static final int VIEW_CHANGE = 6;
    public static final int SET_LOCAL_ADDRESS = 8;
    public static final int SUSPECT = 9;
    public static final int BLOCK = 10;
    public static final int FIND_INITIAL_MBRS = 12;
    public static final int MERGE = 14;
    public static final int TMP_VIEW = 15;
    public static final int BECOME_SERVER = 16;
    public static final int GET_APPLSTATE = 17;
    public static final int GET_STATE = 19;
    public static final int GET_STATE_OK = 20;
    public static final int STATE_RECEIVED = 21;
    public static final int STABLE = 30;
    public static final int GET_DIGEST = 39;
    public static final int SET_DIGEST = 41;
    public static final int EXIT = 46;
    public static final int PERF = 47;
    public static final int HEARD_FROM = 50;
    public static final int UNSUSPECT = 51;
    public static final int MERGE_DIGEST = 53;
    public static final int CONFIG = 56;
    public static final int SUSPEND_STABLE = 65;
    public static final int RESUME_STABLE = 66;
    public static final int SUSPEND = 68;
    public static final int RESUME = 70;
    public static final int STATE_TRANSFER_INPUTSTREAM = 71;
    public static final int STATE_TRANSFER_OUTPUTSTREAM = 72;
    public static final int STATE_TRANSFER_INPUTSTREAM_CLOSED = 73;
    public static final int STATE_TRANSFER_OUTPUTSTREAM_CLOSED = 74;
    public static final int UNBLOCK = 75;
    public static final int CLOSE_BARRIER = 76;
    public static final int OPEN_BARRIER = 77;
    public static final int REBROADCAST = 78;
    public static final int SHUTDOWN = 79;
    public static final int CONNECT_WITH_STATE_TRANSFER = 80;
    public static final int START_PARTITION = 82;
    public static final int STOP_PARTITION = 83;
    public static final int INFO = 84;
    public static final int PREPARE_VIEW = 86;
    public static final int USER_DEFINED = 1000;
    private final int type;
    private final Object arg;
    public static final Event GET_DIGEST_EVT = new Event(39);

    public Event(int type) {
        this.type = type;
        this.arg = null;
    }

    public Event(int type, Object arg) {
        this.type = type;
        this.arg = arg;
    }

    public final int getType() {
        return this.type;
    }

    public void setType(int type) {
        throw new IllegalAccessError("setType() has been deprecated, to make Events immutable");
    }

    public Object getArg() {
        return this.arg;
    }

    public void setArg(Object arg) {
        throw new IllegalAccessError("setArg() has been deprecated, to make Events immutable");
    }

    public static String type2String(int t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "CONNECT";
            }
            case 4: {
                return "DISCONNECT";
            }
            case 6: {
                return "VIEW_CHANGE";
            }
            case 8: {
                return "SET_LOCAL_ADDRESS";
            }
            case 9: {
                return "SUSPECT";
            }
            case 10: {
                return "BLOCK";
            }
            case 12: {
                return "FIND_INITIAL_MBRS";
            }
            case 15: {
                return "TMP_VIEW";
            }
            case 16: {
                return "BECOME_SERVER";
            }
            case 17: {
                return "GET_APPLSTATE";
            }
            case 19: {
                return "GET_STATE";
            }
            case 20: {
                return "GET_STATE_OK";
            }
            case 21: {
                return "STATE_RECEIVED";
            }
            case 30: {
                return "STABLE";
            }
            case 39: {
                return "GET_DIGEST";
            }
            case 41: {
                return "SET_DIGEST";
            }
            case 14: {
                return "MERGE";
            }
            case 46: {
                return "EXIT";
            }
            case 47: {
                return "PERF";
            }
            case 50: {
                return "HEARD_FROM";
            }
            case 51: {
                return "UNSUSPECT";
            }
            case 53: {
                return "MERGE_DIGEST";
            }
            case 56: {
                return "CONFIG";
            }
            case 65: {
                return "SUSPEND_STABLE";
            }
            case 66: {
                return "RESUME_STABLE";
            }
            case 68: {
                return "SUSPEND";
            }
            case 70: {
                return "RESUME";
            }
            case 71: {
                return "STATE_TRANSFER_INPUTSTREAM";
            }
            case 72: {
                return "STATE_TRANSFER_OUTPUTSTREAM";
            }
            case 73: {
                return "STATE_TRANSFER_INPUTSTREAM_CLOSED";
            }
            case 74: {
                return "STATE_TRANSFER_OUTPUTSTREAM_CLOSED";
            }
            case 75: {
                return "UNBLOCK";
            }
            case 76: {
                return "CLOSE_BARRIER";
            }
            case 77: {
                return "OPEN_BARRIER";
            }
            case 78: {
                return "REBROADCAST";
            }
            case 79: {
                return "SHUTDOWN";
            }
            case 80: {
                return "CONNECT_WITH_STATE_TRANSFER";
            }
            case 82: {
                return "START_PARTITION";
            }
            case 83: {
                return "STOP_PARTITION";
            }
            case 84: {
                return "INFO";
            }
            case 86: {
                return "PREPARE_VIEW";
            }
            case 1000: {
                return "USER_DEFINED";
            }
        }
        return "UNDEFINED(" + t + ")";
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("Event[type=" + Event.type2String(this.type) + ", arg=" + this.arg + ']');
        if (this.type == 1) {
            ret.append(" (headers=").append(((Message)this.arg).printHeaders()).append(")");
        }
        return ret.toString();
    }
}

