/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.persistence;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.persistence.DBPersistenceManager;
import org.jgroups.persistence.FilePersistenceManager;
import org.jgroups.persistence.PersistenceManager;
import org.jgroups.util.Util;

public class PersistenceFactory {
    protected static final Log log = LogFactory.getLog(PersistenceFactory.class);
    private static volatile PersistenceManager _manager = null;
    private static volatile PersistenceFactory _factory = null;
    static final String propPath = "persist.properties";
    static final String persistProp = "persist";
    static final String filePersistMgr = "filePersistMgr";

    private PersistenceFactory() {
    }

    public static PersistenceFactory getInstance() {
        log.debug((Object)" getting factory instance ");
        if (_factory == null) {
            _factory = new PersistenceFactory();
        }
        return _factory;
    }

    public synchronized void registerManager(PersistenceManager manager) {
        _manager = manager;
    }

    public synchronized PersistenceManager createManager() throws Exception {
        if (_manager == null) {
            _manager = this.checkDB() ? this.createManagerDB(propPath) : this.createManagerFile(propPath);
        }
        return _manager;
    }

    public synchronized PersistenceManager createManager(String filePath) throws Exception {
        if (_manager == null) {
            _manager = this.checkDB(filePath) ? this.createManagerDB(filePath) : this.createManagerFile(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerDB(String filePath) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Calling db persist from factory: " + filePath));
        }
        if (_manager == null) {
            _manager = new DBPersistenceManager(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerFile(String filePath) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating file manager: " + filePath));
        }
        try {
            if (_manager == null) {
                Properties props = this.readProps(filePath);
                String classname = props.getProperty(filePersistMgr);
                if (classname != null) {
                    Class cl = Util.loadClass(classname, this.getClass());
                    Constructor ctor = cl.getConstructor(String.class);
                    _manager = (PersistenceManager)ctor.newInstance(filePath);
                } else {
                    _manager = new FilePersistenceManager(filePath);
                }
            }
            return _manager;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private boolean checkDB() throws Exception {
        Properties props = this.readProps(propPath);
        String persist = props.getProperty(persistProp);
        return "DB".equals(persist);
    }

    private boolean checkDB(String filePath) throws Exception {
        Properties props = this.readProps(filePath);
        String persist = props.getProperty(persistProp);
        return "DB".equals(persist);
    }

    Properties readProps(String fileName) throws IOException {
        FileInputStream _stream = new FileInputStream(fileName);
        Properties props = new Properties();
        props.load(_stream);
        return props;
    }
}

