/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.spi.scope;

import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

/**
 * CommonLevels util class.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class CommonLevelsUtil
{
   private final static List<ScopeLevel> levels;
   private static final int size;

   static
   {
      levels = new ArrayList<ScopeLevel>();
      levels.add(CommonLevels.DOMAIN);
      levels.add(CommonLevels.CLUSTER);
      levels.add(CommonLevels.MACHINE);
      levels.add(CommonLevels.NODE);
      levels.add(CommonLevels.JVM);
      levels.add(CommonLevels.SERVER);
      levels.add(CommonLevels.SUBSYSTEM);
      levels.add(CommonLevels.APPLICATION);
      levels.add(CommonLevels.DEPLOYMENT);
      levels.add(CommonLevels.CLASS);
      levels.add(CommonLevels.INSTANCE);
      levels.add(CommonLevels.JOINPOINT);
      levels.add(CommonLevels.JOINPOINT_OVERRIDE);
      levels.add(CommonLevels.THREAD);
      levels.add(CommonLevels.WORK);
      levels.add(CommonLevels.REQUEST);
      Collections.sort(levels);
      size = levels.size();
   }

   /**
    * Get the levels (including level param) that
    * are below level param.
    *
    * @param level the flag level
    * @return sub list of levels
    */
   public static List<ScopeLevel> getSubLevels(ScopeLevel level)
   {
      int index = levels.indexOf(level);
      if (index < 0)
         throw new IllegalArgumentException("No such scope level in levels: " + level);
      return levels.subList(index, size);
   }

   /**
    * Get the levels that are exclusively below level param.
    *
    * @param level the flag level
    * @return sub list of levels
    */
   public static List<ScopeLevel> getExclusiveSubLevels(ScopeLevel level)
   {
      int index = levels.indexOf(level);
      if (index < 0)
         throw new IllegalArgumentException("No such scope level in levels: " + level);

      if (index + 1 == size)
         return Collections.emptyList();

      return levels.subList(index + 1, size);
   }
}
