/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class IntegerType
extends PrimitiveType
implements DiscriminatorType,
VersionType {
    private static final Integer ZERO = 0;

    public Serializable getDefaultValue() {
        return ZERO;
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        return new Integer(rs.getInt(name));
    }

    public Class getPrimitiveClass() {
        return Integer.TYPE;
    }

    public Class getReturnedClass() {
        return Integer.class;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setInt(index, (Integer)value);
    }

    public int sqlType() {
        return 4;
    }

    public String getName() {
        return "integer";
    }

    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return value.toString();
    }

    public Object stringToObject(String xml) throws Exception {
        return new Integer(xml);
    }

    public Object next(Object current, SessionImplementor session) {
        return new Integer((Integer)current + 1);
    }

    public Object seed(SessionImplementor session) {
        return ZERO;
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public Object fromStringValue(String xml) {
        return new Integer(xml);
    }
}

