/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.converter;

import java.util.Collection;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class EnumConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent comp, String value) throws ConverterException {
        Class enumType;
        ValueExpression expr = comp.getValueExpression("value");
        Class clazz = enumType = expr == null ? null : expr.getType(context.getELContext());
        if (enumType != null && enumType.isEnum()) {
            return Enum.valueOf(enumType, value);
        }
        for (UIComponent child : comp.getChildren()) {
            Object val;
            if (!(child instanceof UIComponent)) continue;
            UIComponent c = child;
            expr = c.getValueExpression("value");
            Object object = val = expr == null ? null : expr.getValue(context.getELContext());
            if (val == null) {
                throw new ConverterException("Cannot get items");
            }
            Class<Object> t = val.getClass();
            if (t.isArray() && t.getComponentType().isEnum()) {
                return Enum.valueOf(t.getComponentType(), value);
            }
            if (!(val instanceof Collection)) continue;
            Object firstItem = ((Collection)val).iterator().next();
            t = firstItem instanceof Enum ? ((Enum)firstItem).getDeclaringClass() : firstItem.getClass();
            return Enum.valueOf(t, value);
        }
        throw new ConverterException("Unable to find selectItems with enum values.");
    }

    public String getAsString(FacesContext context, UIComponent component, Object object) throws ConverterException {
        return object == null ? null : ((Enum)object).name();
    }
}

