/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.remoting.InvokerLocator;

public class PojiProxy
implements Serializable,
InvocationHandler {
    private static final long serialVersionUID = 8054816523858555978L;
    private Object oid;
    private InvokerLocator uri;
    private Interceptor[] interceptors;

    public PojiProxy(Object oid, InvokerLocator uri, Interceptor[] interceptors) {
        this.oid = oid;
        this.uri = uri;
        this.interceptors = interceptors;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInvocation sri = this.constructMethodInvocation(method, args);
        this.addMetadataToInvocation(sri);
        this.addArgumentsToInvocation(sri, args);
        return sri.invokeNext();
    }

    protected MethodInvocation constructMethodInvocation(Method method, Object[] args) {
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
        return sri;
    }

    protected void addMetadataToInvocation(MethodInvocation methodInvocation) {
        methodInvocation.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", this.oid, PayloadKey.AS_IS);
        methodInvocation.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)this.uri, PayloadKey.TRANSIENT);
        methodInvocation.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.TRANSIENT);
    }

    protected void addArgumentsToInvocation(MethodInvocation invocation, Object[] originalArguments) {
        invocation.setArguments(originalArguments);
    }

    protected Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    protected Object getOid() {
        return this.oid;
    }

    protected InvokerLocator getUri() {
        return this.uri;
    }
}

