/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import javax.jms.MessageListener;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.jms.client.container.ClientConsumer;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.exception.MessagingShutdownException;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.CompatibleExecutor;
import org.jboss.messaging.util.MessageQueueNameHelper;

public class ConsumerAspect {
    private static final Logger log = Logger.getLogger(ConsumerAspect.class);

    public Object handleCreateConsumerDelegate(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        ConsumerDelegate consumerDelegate = (ConsumerDelegate)invocation.invokeNext();
        boolean isCC = (Boolean)mi.getArguments()[4];
        SessionState sessionState = (SessionState)((DelegateSupport)invocation.getTargetObject()).getState();
        ConnectionState connectionState = (ConnectionState)sessionState.getParent();
        SessionDelegate sessionDelegate = (SessionDelegate)invocation.getTargetObject();
        ConsumerState consumerState = (ConsumerState)((DelegateSupport)((Object)consumerDelegate)).getState();
        String consumerID = consumerState.getConsumerID();
        int prefetchSize = consumerState.getBufferSize();
        CompatibleExecutor executor = sessionState.getExecutor();
        int maxDeliveries = consumerState.getMaxDeliveries();
        long redeliveryDelay = consumerState.getRedeliveryDelay();
        FailoverCommandCenter fcc = connectionState.getFailoverCommandCenter();
        String queueName = null;
        if (consumerState.getSubscriptionName() != null) {
            queueName = MessageQueueNameHelper.createSubscriptionName(((ConnectionDelegate)((Object)connectionState.getDelegate())).getClientID(), consumerState.getSubscriptionName());
        } else if (consumerState.getDestination().isQueue()) {
            queueName = consumerState.getDestination().getName();
        }
        boolean autoFlowControl = (Boolean)mi.getArguments()[5];
        CallbackManager cm = connectionState.getRemotingConnection().getCallbackManager();
        ClientConsumer messageHandler = new ClientConsumer(isCC, sessionState.getAcknowledgeMode(), sessionDelegate, consumerDelegate, consumerID, queueName, prefetchSize, executor, maxDeliveries, consumerState.isShouldAck(), redeliveryDelay, consumerState.getMaxRetryChangeRate(), consumerState.getRetryChangeRateInterval(), fcc != null, cm, consumerState.getMinTimeoutProcessTime());
        sessionState.addCallbackHandler(messageHandler);
        cm.registerHandler(consumerID, messageHandler);
        consumerState.setClientConsumer(messageHandler);
        if (autoFlowControl) {
            messageHandler.sendChangeRateMessage(1.0f);
        }
        return consumerDelegate;
    }

    public Object handleClosing(Invocation invocation) throws Throwable {
        ConsumerState consumerState = this.getState(invocation);
        try {
            Long l = (Long)invocation.invokeNext();
            long lastDeliveryId = l;
            consumerState.getClientConsumer().close(lastDeliveryId);
            SessionState sessionState = (SessionState)consumerState.getParent();
            ConnectionState connectionState = (ConnectionState)sessionState.getParent();
            sessionState.removeCallbackHandler(consumerState.getClientConsumer());
            CallbackManager cm = connectionState.getRemotingConnection().getCallbackManager();
            cm.unregisterHandler(consumerState.getConsumerID());
            consumerState.getClientConsumer().cancelBuffer();
            return l;
        }
        catch (Exception proxiedException) {
            ConnectionState connectionState = (ConnectionState)consumerState.getParent().getParent();
            if ((proxiedException instanceof MessagingShutdownException || connectionState.getFailoverCommandCenter() == null) && !consumerState.getClientConsumer().isClosed()) {
                consumerState.getClientConsumer().close(-1L);
            }
            throw proxiedException;
        }
    }

    public Object handleReceive(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Object[] args = mi.getArguments();
        long timeout = args == null || args.length == 0 ? 0L : (Long)args[0];
        return this.getClientConsumer(invocation).receive(timeout);
    }

    public Object handleReceiveNoWait(Invocation invocation) throws Throwable {
        return this.getClientConsumer(invocation).receive(-1L);
    }

    public Object handleSetMessageListener(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        Object[] args = mi.getArguments();
        MessageListener l = (MessageListener)args[0];
        this.getClientConsumer(invocation).setMessageListener(l);
        return null;
    }

    public MessageListener handleGetMessageListener(Invocation invocation) throws Throwable {
        return this.getClientConsumer(invocation).getMessageListener();
    }

    public Object handleGetDestination(Invocation invocation) throws Throwable {
        return this.getState(invocation).getDestination();
    }

    public Object handleGetNoLocal(Invocation invocation) throws Throwable {
        return this.getState(invocation).isNoLocal() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object handleGetMessageSelector(Invocation invocation) throws Throwable {
        return this.getState(invocation).getSelector();
    }

    private ConsumerState getState(Invocation inv) {
        return (ConsumerState)((DelegateSupport)inv.getTargetObject()).getState();
    }

    private ClientConsumer getClientConsumer(Invocation inv) {
        ConsumerState state = (ConsumerState)((DelegateSupport)inv.getTargetObject()).getState();
        return state.getClientConsumer();
    }
}

