/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.RequestEntity;

public class StringRequestEntity
implements RequestEntity {
    private byte[] content;
    private String charset;
    private String contentType;

    public StringRequestEntity(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The content cannot be null");
        }
        this.contentType = null;
        this.charset = null;
        this.content = string.getBytes();
    }

    public StringRequestEntity(String string, String string2, String string3) throws UnsupportedEncodingException {
        if (string == null) {
            throw new IllegalArgumentException("The content cannot be null");
        }
        this.contentType = string2;
        this.charset = string3;
        if (string2 != null) {
            HeaderElement[] headerElementArray = HeaderElement.parseElements(string2);
            NameValuePair nameValuePair = null;
            for (int i = 0; i < headerElementArray.length && (nameValuePair = headerElementArray[i].getParameterByName("charset")) == null; ++i) {
            }
            if (string3 == null && nameValuePair != null) {
                this.charset = nameValuePair.getValue();
            } else if (string3 != null && nameValuePair == null) {
                this.contentType = string2 + "; charset=" + string3;
            }
        }
        this.content = this.charset != null ? string.getBytes(this.charset) : string.getBytes();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void writeRequest(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outputStream.write(this.content);
        outputStream.flush();
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    public String getContent() {
        if (this.charset != null) {
            try {
                return new String(this.content, this.charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.content);
            }
        }
        return new String(this.content);
    }

    public String getCharset() {
        return this.charset;
    }
}

