/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.readers;

import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.Resolver;
import org.apache.xml.resolver.readers.OASISXMLCatalogReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExtendedXMLCatalogReader
extends OASISXMLCatalogReader {
    public static final String extendedNamespaceName = "http://nwalsh.com/xcatalog/1.0";

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block17: {
            boolean bl = this.inExtensionNamespace();
            super.startElement(string, string2, string3, attributes);
            int n = -1;
            Vector<String> vector = new Vector<String>();
            if (string != null && extendedNamespaceName.equals(string) && !bl) {
                Object object;
                if (attributes.getValue("xml:base") != null) {
                    block16: {
                        object = attributes.getValue("xml:base");
                        n = Catalog.BASE;
                        vector.add((String)object);
                        this.baseURIStack.push(object);
                        this.debug.message(4, "xml:base", (String)object);
                        try {
                            CatalogEntry catalogEntry = new CatalogEntry(n, vector);
                            this.catalog.addEntry(catalogEntry);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string2);
                            }
                            if (catalogException.getExceptionType() != 2) break block16;
                            this.debug.message(1, "Invalid catalog entry (base)", string2);
                        }
                    }
                    n = -1;
                    vector = new Vector();
                } else {
                    this.baseURIStack.push(this.baseURIStack.peek());
                }
                if (string2.equals("uriSuffix")) {
                    if (this.checkAttributes(attributes, "suffix", "uri")) {
                        n = Resolver.URISUFFIX;
                        vector.add(attributes.getValue("suffix"));
                        vector.add(attributes.getValue("uri"));
                        this.debug.message(4, "uriSuffix", attributes.getValue("suffix"), attributes.getValue("uri"));
                    }
                } else if (string2.equals("systemSuffix")) {
                    if (this.checkAttributes(attributes, "suffix", "uri")) {
                        n = Resolver.SYSTEMSUFFIX;
                        vector.add(attributes.getValue("suffix"));
                        vector.add(attributes.getValue("uri"));
                        this.debug.message(4, "systemSuffix", attributes.getValue("suffix"), attributes.getValue("uri"));
                    }
                } else {
                    this.debug.message(1, "Invalid catalog entry type", string2);
                }
                if (n >= 0) {
                    try {
                        object = new CatalogEntry(n, vector);
                        this.catalog.addEntry((CatalogEntry)object);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", string2);
                        }
                        if (catalogException.getExceptionType() != 2) break block17;
                        this.debug.message(1, "Invalid catalog entry", string2);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        block5: {
            super.endElement(string, string2, string3);
            boolean bl = this.inExtensionNamespace();
            int n = -1;
            Vector<String> vector = new Vector<String>();
            if (string != null && extendedNamespaceName.equals(string) && !bl) {
                String string4 = (String)this.baseURIStack.pop();
                String string5 = (String)this.baseURIStack.peek();
                if (!string5.equals(string4)) {
                    n = Catalog.BASE;
                    vector.add(string5);
                    this.debug.message(4, "(reset) xml:base", string5);
                    try {
                        CatalogEntry catalogEntry = new CatalogEntry(n, vector);
                        this.catalog.addEntry(catalogEntry);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", string2);
                        }
                        if (catalogException.getExceptionType() != 2) break block5;
                        this.debug.message(1, "Invalid catalog entry (rbase)", string2);
                    }
                }
            }
        }
    }
}

