/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.evt.WEvent;
import com.ctc.wstx.evt.WNamespace;
import com.ctc.wstx.util.EmptyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;

public class WEndElement
extends WEvent
implements EndElement {
    final QName mName;
    final ArrayList mNamespaces;

    public WEndElement(Location loc, XMLStreamReader r) {
        super(loc);
        this.mName = r.getName();
        int nsCount = r.getNamespaceCount();
        if (nsCount == 0) {
            this.mNamespaces = null;
        } else {
            ArrayList<WNamespace> l = new ArrayList<WNamespace>(nsCount);
            for (int i = 0; i < nsCount; ++i) {
                String prefix = r.getNamespacePrefix(i);
                if (prefix == null || prefix.length() == 0) {
                    l.add(new WNamespace(loc, r.getNamespaceURI(i)));
                    continue;
                }
                l.add(new WNamespace(loc, prefix, r.getNamespaceURI(i)));
            }
            this.mNamespaces = l;
        }
    }

    public WEndElement(Location loc, QName name, Iterator namespaces) {
        super(loc);
        this.mName = name;
        if (namespaces == null || !namespaces.hasNext()) {
            this.mNamespaces = null;
        } else {
            ArrayList<Namespace> l = new ArrayList<Namespace>();
            while (namespaces.hasNext()) {
                l.add((Namespace)namespaces.next());
            }
            this.mNamespaces = l;
        }
    }

    @Override
    public QName getName() {
        return this.mName;
    }

    public Iterator getNamespaces() {
        return this.mNamespaces == null ? EmptyIterator.getInstance() : this.mNamespaces.iterator();
    }

    @Override
    public EndElement asEndElement() {
        return this;
    }

    @Override
    public int getEventType() {
        return 2;
    }

    @Override
    public boolean isEndElement() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            w.write("</");
            String prefix = this.mName.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                w.write(prefix);
                w.write(58);
            }
            w.write(this.mName.getLocalPart());
            w.write(62);
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter w) throws XMLStreamException {
        w.writeEndElement();
    }
}

