/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profileservice.repository;

import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.Profile;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 86190 $
 */
public abstract class AbstractProfileAction
{
   /** The logger. */
   protected final Logger log = Logger.getLogger(getClass());
   
   public abstract void install(Profile profile) throws Exception;
   
   public abstract void uninstall(Profile profile);
   
   /**
    * Install.
    * 
    * @param context the profile context.
    * @throws Exception
    */
   public void install(ProfileContext context) throws Exception
   {
      Profile profile = context.getProfile();
      if(profile == null)
         return;
      
      // Install
      install(profile);
   }
   
   /**
    * Uninstall.
    * 
    * @param context the profile context.
    */
   public void uninstall(ProfileContext context)
   {
      Profile profile = context.getProfile();
      if(profile == null)
         return;
    
      try
      {
         // Uninstall
         uninstall(profile);
      }
      catch (Throwable t)
      {
         log.error("Error when uninstalling profile: " + profile, t);
      }
   }
}

