/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.MarkerObject;

public abstract class AbstractPersistentCollection
implements Serializable,
PersistentCollection {
    private transient SessionImplementor session;
    private boolean initialized;
    private transient List operationQueue;
    private transient boolean directlyAccessible;
    private transient boolean initializing;
    private Object owner;
    private int cachedSize = -1;
    private String role;
    private Serializable key;
    private boolean dirty;
    private Serializable storedSnapshot;
    protected static final Object UNKNOWN = new MarkerObject("UNKNOWN");

    @Override
    public final String getRole() {
        return this.role;
    }

    @Override
    public final Serializable getKey() {
        return this.key;
    }

    @Override
    public final boolean isUnreferenced() {
        return this.role == null;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
    }

    @Override
    public final void dirty() {
        this.dirty = true;
    }

    @Override
    public final Serializable getStoredSnapshot() {
        return this.storedSnapshot;
    }

    @Override
    public abstract boolean empty();

    protected final void read() {
        this.initialize(false);
    }

    protected boolean readSize() {
        if (!this.initialized) {
            if (this.cachedSize != -1 && !this.hasQueuedOperations()) {
                return true;
            }
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry entry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister persister = entry.getLoadedPersister();
            if (persister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                this.cachedSize = persister.getSize(entry.getLoadedKey(), this.session);
                return true;
            }
        }
        this.read();
        return false;
    }

    protected Boolean readIndexExistence(Object index) {
        if (!this.initialized) {
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry entry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister persister = entry.getLoadedPersister();
            if (persister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                return persister.indexExists(entry.getLoadedKey(), index, this.session);
            }
        }
        this.read();
        return null;
    }

    protected Boolean readElementExistence(Object element) {
        if (!this.initialized) {
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry entry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister persister = entry.getLoadedPersister();
            if (persister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                return persister.elementExists(entry.getLoadedKey(), element, this.session);
            }
        }
        this.read();
        return null;
    }

    protected Object readElementByIndex(Object index) {
        if (!this.initialized) {
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry entry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister persister = entry.getLoadedPersister();
            if (persister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                return persister.getElementByIndex(entry.getLoadedKey(), index, this.session, this.owner);
            }
        }
        this.read();
        return UNKNOWN;
    }

    protected int getCachedSize() {
        return this.cachedSize;
    }

    private final boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen() && this.session.getPersistenceContext().containsCollection(this);
    }

    protected final void write() {
        this.initialize(true);
        this.dirty();
    }

    protected boolean isOperationQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollection();
    }

    protected boolean isPutQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseOneToManyOrNoOrphanDelete();
    }

    protected boolean isClearQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollectionNoOrphanDelete();
    }

    private boolean isInverseCollection() {
        CollectionEntry ce = this.session.getPersistenceContext().getCollectionEntry(this);
        return ce != null && ce.getLoadedPersister().isInverse();
    }

    private boolean isInverseCollectionNoOrphanDelete() {
        CollectionEntry ce = this.session.getPersistenceContext().getCollectionEntry(this);
        return ce != null && ce.getLoadedPersister().isInverse() && !ce.getLoadedPersister().hasOrphanDelete();
    }

    private boolean isInverseOneToManyOrNoOrphanDelete() {
        CollectionEntry ce = this.session.getPersistenceContext().getCollectionEntry(this);
        return ce != null && ce.getLoadedPersister().isInverse() && (ce.getLoadedPersister().isOneToMany() || !ce.getLoadedPersister().hasOrphanDelete());
    }

    protected final void queueOperation(Object element) {
        if (this.operationQueue == null) {
            this.operationQueue = new ArrayList(10);
        }
        this.operationQueue.add(element);
        this.dirty = true;
    }

    protected final void performQueuedOperations() {
        for (int i = 0; i < this.operationQueue.size(); ++i) {
            ((DelayedOperation)this.operationQueue.get(i)).operate();
        }
    }

    @Override
    public void setSnapshot(Serializable key, String role, Serializable snapshot) {
        this.key = key;
        this.role = role;
        this.storedSnapshot = snapshot;
    }

    @Override
    public void postAction() {
        this.operationQueue = null;
        this.cachedSize = -1;
        this.clearDirty();
    }

    public AbstractPersistentCollection() {
    }

    protected AbstractPersistentCollection(SessionImplementor session) {
        this.session = session;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void beginRead() {
        this.initializing = true;
    }

    @Override
    public boolean endRead() {
        return this.afterInitialize();
    }

    @Override
    public boolean afterInitialize() {
        this.setInitialized();
        if (this.operationQueue != null) {
            this.performQueuedOperations();
            this.operationQueue = null;
            this.cachedSize = -1;
            return false;
        }
        return true;
    }

    protected final void initialize(boolean writing) {
        if (!this.initialized) {
            if (this.initializing) {
                throw new LazyInitializationException("illegal access to loading collection");
            }
            this.throwLazyInitializationExceptionIfNotConnected();
            this.session.initializeCollection(this, writing);
        }
    }

    private void throwLazyInitializationExceptionIfNotConnected() {
        if (!this.isConnectedToSession()) {
            this.throwLazyInitializationException("no session or session was closed");
        }
        if (!this.session.isConnected()) {
            this.throwLazyInitializationException("session is disconnected");
        }
    }

    private void throwLazyInitializationException(String message) {
        throw new LazyInitializationException("failed to lazily initialize a collection" + (this.role == null ? "" : " of role: " + this.role) + ", " + message);
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    protected final void setDirectlyAccessible(boolean directlyAccessible) {
        this.directlyAccessible = directlyAccessible;
    }

    @Override
    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    @Override
    public final boolean unsetSession(SessionImplementor currentSession) {
        if (currentSession == this.session) {
            this.session = null;
            return true;
        }
        return false;
    }

    @Override
    public final boolean setCurrentSession(SessionImplementor session) throws HibernateException {
        if (session == this.session) {
            return false;
        }
        if (this.isConnectedToSession()) {
            CollectionEntry ce = session.getPersistenceContext().getCollectionEntry(this);
            if (ce == null) {
                throw new HibernateException("Illegal attempt to associate a collection with two open sessions");
            }
            throw new HibernateException("Illegal attempt to associate a collection with two open sessions: " + MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), session.getFactory()));
        }
        this.session = session;
        return true;
    }

    @Override
    public boolean needsRecreate(CollectionPersister persister) {
        return false;
    }

    @Override
    public final void forceInitialization() throws HibernateException {
        if (!this.initialized) {
            if (this.initializing) {
                throw new AssertionFailure("force initialize loading collection");
            }
            if (this.session == null) {
                throw new HibernateException("collection is not associated with any session");
            }
            if (!this.session.isConnected()) {
                throw new HibernateException("disconnected session");
            }
            this.session.initializeCollection(this, false);
        }
    }

    protected final Serializable getSnapshot() {
        return this.session.getPersistenceContext().getSnapshot(this);
    }

    @Override
    public final boolean wasInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return true;
    }

    @Override
    public final boolean hasQueuedOperations() {
        return this.operationQueue != null;
    }

    @Override
    public final Iterator queuedAdditionIterator() {
        if (this.hasQueuedOperations()) {
            return new Iterator(){
                int i = 0;

                public Object next() {
                    return ((DelayedOperation)AbstractPersistentCollection.this.operationQueue.get(this.i++)).getAddedInstance();
                }

                @Override
                public boolean hasNext() {
                    return this.i < AbstractPersistentCollection.this.operationQueue.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return EmptyIterator.INSTANCE;
    }

    @Override
    public final Collection getQueuedOrphans(String entityName) {
        if (this.hasQueuedOperations()) {
            ArrayList<Object> additions = new ArrayList<Object>(this.operationQueue.size());
            ArrayList<Object> removals = new ArrayList<Object>(this.operationQueue.size());
            for (int i = 0; i < this.operationQueue.size(); ++i) {
                DelayedOperation op = (DelayedOperation)this.operationQueue.get(i);
                additions.add(op.getAddedInstance());
                removals.add(op.getOrphan());
            }
            return AbstractPersistentCollection.getOrphans(removals, additions, entityName, this.session);
        }
        return CollectionHelper.EMPTY_COLLECTION;
    }

    @Override
    public void preInsert(CollectionPersister persister) throws HibernateException {
    }

    @Override
    public void afterRowInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
    }

    @Override
    public abstract Collection getOrphans(Serializable var1, String var2) throws HibernateException;

    public final SessionImplementor getSession() {
        return this.session;
    }

    protected static Collection getOrphans(Collection oldElements, Collection currentElements, String entityName, SessionImplementor session) throws HibernateException {
        if (currentElements.size() == 0) {
            return oldElements;
        }
        if (oldElements.size() == 0) {
            return oldElements;
        }
        Type idType = session.getFactory().getEntityPersister(entityName).getIdentifierType();
        ArrayList res = new ArrayList();
        HashSet<TypedValue> currentIds = new HashSet<TypedValue>();
        for (Object current : currentElements) {
            if (current == null || !ForeignKeys.isNotTransient(entityName, current, null, session)) continue;
            Serializable currentId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, current, session);
            currentIds.add(new TypedValue(idType, currentId, session.getEntityMode()));
        }
        for (Object old : oldElements) {
            Serializable oldId = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, old, session);
            if (currentIds.contains(new TypedValue(idType, oldId, session.getEntityMode()))) continue;
            res.add(old);
        }
        return res;
    }

    static void identityRemove(Collection list, Object object, String entityName, SessionImplementor session) throws HibernateException {
        if (object != null && ForeignKeys.isNotTransient(entityName, object, null, session)) {
            Type idType = session.getFactory().getEntityPersister(entityName).getIdentifierType();
            Serializable idOfCurrent = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, object, session);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Serializable idOfOld = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityName, iter.next(), session);
                if (!idType.isEqual(idOfCurrent, idOfOld, session.getEntityMode(), session.getFactory())) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public Object getIdentifier(Object entry, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    protected static interface DelayedOperation {
        public void operate();

        public Object getAddedInstance();

        public Object getOrphan();
    }

    final class ListProxy
    implements List {
        private final List list;

        ListProxy(List list) {
            this.list = list;
        }

        public void add(int index, Object value) {
            AbstractPersistentCollection.this.write();
            this.list.add(index, value);
        }

        @Override
        public boolean add(Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.add(o);
        }

        @Override
        public boolean addAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(c);
        }

        public boolean addAll(int i, Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(i, c);
        }

        @Override
        public void clear() {
            AbstractPersistentCollection.this.write();
            this.list.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return new ListIteratorProxy(this.list.listIterator(i));
        }

        public Object remove(int i) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(i);
        }

        @Override
        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(o);
        }

        @Override
        public boolean removeAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.list.retainAll(c);
        }

        public Object set(int i, Object o) {
            AbstractPersistentCollection.this.write();
            return this.list.set(i, o);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        public List subList(int i, int j) {
            return this.list.subList(i, j);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.list.toArray(array);
        }
    }

    class SetProxy
    implements Set {
        final Collection set;

        SetProxy(Collection set) {
            this.set = set;
        }

        @Override
        public boolean add(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.add(o);
        }

        @Override
        public boolean addAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.addAll(c);
        }

        @Override
        public void clear() {
            AbstractPersistentCollection.this.write();
            this.set.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        @Override
        public boolean remove(Object o) {
            AbstractPersistentCollection.this.write();
            return this.set.remove(o);
        }

        @Override
        public boolean removeAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            AbstractPersistentCollection.this.write();
            return this.set.retainAll(c);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            return this.set.toArray(array);
        }
    }

    final class ListIteratorProxy
    implements ListIterator {
        private final ListIterator iter;

        ListIteratorProxy(ListIterator iter) {
            this.iter = iter;
        }

        public void add(Object o) {
            AbstractPersistentCollection.this.write();
            this.iter.add(o);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public Object next() {
            return this.iter.next();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            return this.iter.previous();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.write();
            this.iter.remove();
        }

        public void set(Object o) {
            AbstractPersistentCollection.this.write();
            this.iter.set(o);
        }
    }

    final class IteratorProxy
    implements Iterator {
        private final Iterator iter;

        IteratorProxy(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            AbstractPersistentCollection.this.write();
            this.iter.remove();
        }
    }
}

