/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.JBossExecutors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedExecutorService
extends AbstractExecutorService
implements ExecutorService {
    private final Executor delegate;

    public ProtectedExecutorService(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        unit.sleep(timeout);
        return false;
    }

    @Override
    public void shutdown() {
        throw new SecurityException("shutdown() not allowed on container-managed executor");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new SecurityException("shutdownNow() not allowed on container-managed executor");
    }

    public static ExecutorService directExecutorService() {
        return new ProtectedExecutorService(JBossExecutors.directExecutor());
    }
}

