/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.ReaderFactory;
import hidden.org.codehaus.plexus.util.xml.XmlStreamReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataReadException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultRepositoryMetadataManager
extends AbstractLogEnabled
implements RepositoryMetadataManager {
    private WagonManager wagonManager;
    private Set cachedMetadata = new HashSet();

    public void resolve(RepositoryMetadata metadata, List remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataResolutionException {
        boolean alreadyResolved = this.alreadyResolved(metadata);
        if (!alreadyResolved) {
            Iterator i = remoteRepositories.iterator();
            while (i.hasNext()) {
                ArtifactRepositoryPolicy policy;
                ArtifactRepository repository = (ArtifactRepository)i.next();
                ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
                if (!policy.isEnabled()) {
                    this.getLogger().debug("Skipping disabled repository " + repository.getId());
                    continue;
                }
                if (repository.isBlacklisted()) {
                    this.getLogger().debug("Skipping blacklisted repository " + repository.getId());
                    continue;
                }
                File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, repository));
                boolean checkForUpdates = !file.exists() || policy.checkOutOfDate(new Date(file.lastModified()));
                if (!checkForUpdates) continue;
                if (this.wagonManager.isOnline()) {
                    this.getLogger().info(metadata.getKey() + ": checking for updates from " + repository.getId());
                    boolean storeMetadata = false;
                    try {
                        this.wagonManager.getArtifactMetadata(metadata, repository, file, policy.getChecksumPolicy());
                        storeMetadata = true;
                    }
                    catch (ResourceDoesNotExistException e) {
                        this.getLogger().debug(metadata + " could not be found on repository: " + repository.getId());
                        if (file.exists()) {
                            file.delete();
                        }
                        storeMetadata = true;
                    }
                    catch (TransferFailedException e) {
                        this.getLogger().warn(metadata + " could not be retrieved from repository: " + repository.getId() + " due to an error: " + e.getMessage());
                        this.getLogger().debug("Exception", e);
                        this.getLogger().info("Repository '" + repository.getId() + "' will be blacklisted");
                        repository.setBlacklisted(true);
                    }
                    if (!storeMetadata) continue;
                    if (file.exists()) {
                        file.setLastModified(System.currentTimeMillis());
                        continue;
                    }
                    try {
                        metadata.storeInLocalRepository(localRepository, repository);
                        continue;
                    }
                    catch (RepositoryMetadataStoreException e) {
                        throw new RepositoryMetadataResolutionException("Unable to store local copy of metadata: " + e.getMessage(), e);
                    }
                }
                this.getLogger().debug("System is offline. Cannot resolve metadata:\n" + metadata.extendedToString() + "\n\n");
            }
            this.cachedMetadata.add(metadata.getKey());
        }
        try {
            this.mergeMetadata(metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataResolutionException("Unable to store local copy of metadata: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException("Unable to read local copy of metadata: " + e.getMessage(), e);
        }
    }

    private void mergeMetadata(RepositoryMetadata metadata, List remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataStoreException, RepositoryMetadataReadException {
        HashMap previousMetadata = new HashMap();
        ArtifactRepository selected = null;
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)i.next();
            ArtifactRepositoryPolicy policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
            if (!policy.isEnabled() || !this.loadMetadata(metadata, repository, localRepository, previousMetadata)) continue;
            metadata.setRepository(repository);
            selected = repository;
        }
        if (this.loadMetadata(metadata, localRepository, localRepository, previousMetadata)) {
            metadata.setRepository(null);
            selected = localRepository;
        }
        this.updateSnapshotMetadata(metadata, previousMetadata, selected, localRepository);
    }

    private void updateSnapshotMetadata(RepositoryMetadata metadata, Map previousMetadata, ArtifactRepository selected, ArtifactRepository localRepository) throws RepositoryMetadataStoreException {
        if (metadata.isSnapshot()) {
            Metadata prevMetadata = metadata.getMetadata();
            Iterator i = previousMetadata.keySet().iterator();
            while (i.hasNext()) {
                ArtifactRepository repository = (ArtifactRepository)i.next();
                Metadata m = (Metadata)previousMetadata.get(repository);
                if (repository.equals(selected)) {
                    if (m.getVersioning() == null) {
                        m.setVersioning(new Versioning());
                    }
                    if (m.getVersioning().getSnapshot() != null) continue;
                    m.getVersioning().setSnapshot(new Snapshot());
                    continue;
                }
                if (m.getVersioning() == null || m.getVersioning().getSnapshot() == null || !m.getVersioning().getSnapshot().isLocalCopy()) continue;
                m.getVersioning().getSnapshot().setLocalCopy(false);
                metadata.setMetadata(m);
                metadata.storeInLocalRepository(localRepository, repository);
            }
            metadata.setMetadata(prevMetadata);
        }
    }

    private boolean loadMetadata(RepositoryMetadata repoMetadata, ArtifactRepository remoteRepository, ArtifactRepository localRepository, Map previousMetadata) throws RepositoryMetadataReadException {
        boolean setRepository = false;
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(repoMetadata, remoteRepository));
        if (metadataFile.exists()) {
            Metadata metadata = DefaultRepositoryMetadataManager.readMetadata(metadataFile);
            if (repoMetadata.isSnapshot() && previousMetadata != null) {
                previousMetadata.put(remoteRepository, metadata);
            }
            if (repoMetadata.getMetadata() != null) {
                setRepository = repoMetadata.getMetadata().merge(metadata);
            } else {
                repoMetadata.setMetadata(metadata);
                setRepository = true;
            }
        }
        return setRepository;
    }

    protected static Metadata readMetadata(File mappingFile) throws RepositoryMetadataReadException {
        Metadata result;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(mappingFile);
            MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
            result = mappingReader.read(reader, false);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "'", e);
        }
        catch (IOException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e.getMessage(), e);
        }
        finally {
            IOUtil.close(reader);
        }
        return result;
    }

    public void resolveAlways(RepositoryMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataResolutionException {
        File file;
        if (!this.wagonManager.isOnline()) {
            throw new RepositoryMetadataResolutionException("System is offline. Cannot resolve required metadata:\n" + metadata.extendedToString());
        }
        try {
            file = this.getArtifactMetadataFromDeploymentRepository(metadata, localRepository, remoteRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataResolutionException(metadata + " could not be retrieved from repository: " + remoteRepository.getId() + " due to an error: " + e.getMessage(), e);
        }
        try {
            if (file.exists()) {
                Metadata prevMetadata = DefaultRepositoryMetadataManager.readMetadata(file);
                metadata.setMetadata(prevMetadata);
            }
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException(e.getMessage(), e);
        }
    }

    private File getArtifactMetadataFromDeploymentRepository(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws TransferFailedException {
        File file;
        block2: {
            file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, remoteRepository));
            try {
                this.wagonManager.getArtifactMetadataFromDeploymentRepository(metadata, remoteRepository, file, "warn");
            }
            catch (ResourceDoesNotExistException e) {
                this.getLogger().info(metadata + " could not be found on repository: " + remoteRepository.getId() + ", so will be created");
                if (!file.exists()) break block2;
                file.delete();
            }
        }
        return file;
    }

    private boolean alreadyResolved(ArtifactMetadata metadata) {
        return this.cachedMetadata.contains(metadata.getKey());
    }

    public void deploy(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws RepositoryMetadataDeploymentException {
        File file;
        if (!this.wagonManager.isOnline()) {
            throw new RepositoryMetadataDeploymentException("System is offline. Cannot deploy metadata:\n" + metadata.extendedToString());
        }
        if (metadata instanceof RepositoryMetadata) {
            this.getLogger().info("Retrieving previous metadata from " + deploymentRepository.getId());
            try {
                file = this.getArtifactMetadataFromDeploymentRepository(metadata, localRepository, deploymentRepository);
            }
            catch (TransferFailedException e) {
                throw new RepositoryMetadataDeploymentException(metadata + " could not be retrieved from repository: " + deploymentRepository.getId() + " due to an error: " + e.getMessage(), e);
            }
        } else {
            file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, deploymentRepository));
        }
        try {
            metadata.storeInLocalRepository(localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataDeploymentException("Error installing metadata: " + e.getMessage(), e);
        }
        try {
            this.wagonManager.putArtifactMetadata(file, metadata, deploymentRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataDeploymentException("Error while deploying metadata: " + e.getMessage(), e);
        }
    }

    public void install(ArtifactMetadata metadata, ArtifactRepository localRepository) throws RepositoryMetadataInstallationException {
        try {
            metadata.storeInLocalRepository(localRepository, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataInstallationException("Error installing metadata: " + e.getMessage(), e);
        }
    }
}

