/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.recovery;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.recovery.HornetQResourceRecovery;
import org.hornetq.jms.server.recovery.RecoveryRegistry;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.hornetq.ra.Util;

public class RecoveryManager {
    private static Logger log = Logger.getLogger(RecoveryManager.class);
    private RecoveryRegistry registry;
    private String resourceRecoveryClassNames = "org.jboss.as.integration.hornetq.recovery.AS5RecoveryRegistry";
    private Map<XARecoveryConfig, HornetQResourceRecovery> configMap = new HashMap<XARecoveryConfig, HornetQResourceRecovery>();

    public void start() {
        this.locateRecoveryRegistry();
    }

    public HornetQResourceRecovery register(HornetQConnectionFactory factory, String userName, String password) {
        log.debug((Object)("registering recovery for factory : " + factory));
        if (!this.isRegistered(factory) && this.registry != null) {
            XARecoveryConfig xaRecoveryConfig = new XARecoveryConfig(factory, userName, password);
            HornetQResourceRecovery resourceRecovery = new HornetQResourceRecovery(xaRecoveryConfig);
            this.registry.register(resourceRecovery);
            this.configMap.put(xaRecoveryConfig, resourceRecovery);
            return resourceRecovery;
        }
        return null;
    }

    public void unRegister(HornetQResourceRecovery resourceRecovery) {
        this.registry.unRegister(resourceRecovery);
    }

    public void stop() {
        for (HornetQResourceRecovery hornetQResourceRecovery : this.configMap.values()) {
            this.registry.unRegister(hornetQResourceRecovery);
        }
        this.configMap.clear();
    }

    private void locateRecoveryRegistry() {
        String[] locatorClasses = this.resourceRecoveryClassNames.split(";");
        for (int i = 0; i < locatorClasses.length; ++i) {
            this.registry = Util.locateRecoveryRegistry(locatorClasses[i]);
            if (this.registry != null) break;
        }
        if (this.registry == null) {
            this.registry = new RecoveryRegistry(){

                public void register(HornetQResourceRecovery resourceRecovery) {
                }

                public void unRegister(HornetQResourceRecovery xaRecoveryConfig) {
                }
            };
        } else {
            log.debug((Object)("Recovery Registry located = " + this.registry));
        }
    }

    public boolean isRegistered(HornetQConnectionFactory factory) {
        for (XARecoveryConfig xaRecoveryConfig : this.configMap.keySet()) {
            TransportConfiguration[] transportConfigurations = factory.getServerLocator().getStaticTransportConfigurations();
            if (transportConfigurations != null) {
                TransportConfiguration[] xaConfigurations = xaRecoveryConfig.getHornetQConnectionFactory().getServerLocator().getStaticTransportConfigurations();
                if (xaConfigurations == null || transportConfigurations.length != xaConfigurations.length) break;
                boolean theSame = true;
                for (int i = 0; i < transportConfigurations.length; ++i) {
                    TransportConfiguration tc = transportConfigurations[i];
                    TransportConfiguration xaTc = xaConfigurations[i];
                    if (tc.equals((Object)xaTc)) continue;
                    theSame = false;
                    break;
                }
                if (!theSame) continue;
                return theSame;
            }
            DiscoveryGroupConfiguration discoveryGroupConfiguration = xaRecoveryConfig.getHornetQConnectionFactory().getServerLocator().getDiscoveryGroupConfiguration();
            if (discoveryGroupConfiguration == null || !discoveryGroupConfiguration.equals((Object)factory.getDiscoveryGroupConfiguration())) continue;
            return true;
        }
        return false;
    }
}

