/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.SimpleXpathEngine;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLAssert
extends Assert
implements XSLTConstants {
    protected XMLAssert() {
    }

    public static void assertXMLEqual(Diff diff, boolean assertion) {
        if (assertion != diff.similar()) {
            XMLAssert.fail((String)diff.toString());
        }
    }

    public static void assertXMLEqual(String msg, Diff diff, boolean assertion) {
        if (assertion != diff.similar()) {
            XMLAssert.fail((String)(msg + ", " + diff.toString()));
        }
    }

    public static void assertXMLIdentical(Diff diff, boolean assertion) {
        if (assertion != diff.identical()) {
            XMLAssert.fail((String)diff.toString());
        }
    }

    public static void assertXMLIdentical(Diff diff, boolean assertion, String msg) {
        XMLAssert.assertXMLIdentical(msg, diff, assertion);
    }

    public static void assertXMLIdentical(String msg, Diff diff, boolean assertion) {
        if (assertion != diff.identical()) {
            XMLAssert.fail((String)(msg + ", " + diff.toString()));
        }
    }

    public static void assertXMLEqual(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(diff, true);
    }

    public static void assertXMLEqual(Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(diff, true);
    }

    public static void assertXMLEqual(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(diff, true);
    }

    public static void assertXMLEqual(String err, String control, String test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLEqual(String err, Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, true);
    }

    public static void assertXMLNotEqual(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(diff, false);
    }

    public static void assertXMLNotEqual(String err, String control, String test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(diff, false);
    }

    public static void assertXMLNotEqual(String err, Document control, Document test) {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXMLNotEqual(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(diff, false);
    }

    public static void assertXMLNotEqual(String err, Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        Diff diff = new Diff(control, test);
        XMLAssert.assertXMLEqual(err, diff, false);
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, Document document) throws TransformerException {
        XMLAssert.assertXpathsEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathsEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathsEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        XMLAssert.assertXpathsEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathsEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException {
        SimpleXpathEngine xpath = new SimpleXpathEngine();
        Diff diff = new Diff(xpath.getXPathResultAsDocument(controlXpath, controlDocument), xpath.getXPathResultAsDocument(testXpath, testDocument));
        XMLAssert.assertXMLEqual(diff, true);
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, Document document) throws TransformerException {
        XMLAssert.assertXpathsNotEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathsNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathsNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        XMLAssert.assertXpathsNotEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathsNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException {
        SimpleXpathEngine xpath = new SimpleXpathEngine();
        Diff diff = new Diff(xpath.getXPathResultAsDocument(controlXpath, controlDocument), xpath.getXPathResultAsDocument(testXpath, testDocument));
        XMLAssert.assertXMLEqual(diff, false);
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, Document document) throws TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathValuesEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathValuesEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathValuesEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException, TransformerConfigurationException {
        SimpleXpathEngine xpath = new SimpleXpathEngine();
        XMLAssert.assertEquals((String)xpath.evaluate(controlXpath, controlDocument), (String)xpath.evaluate(testXpath, testDocument));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, XMLUnit.buildControlDocument(inXMLString));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String testXpath, Document document) throws TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, document, testXpath, document);
    }

    public static void assertXpathValuesNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, XMLUnit.buildControlDocument(inControlXMLString), testXpath, XMLUnit.buildTestDocument(inTestXMLString));
    }

    public static void assertXpathValuesNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException, TransformerConfigurationException {
        SimpleXpathEngine xpath = new SimpleXpathEngine();
        String control = xpath.evaluate(controlXpath, controlDocument);
        String test = xpath.evaluate(testXpath, testDocument);
        if (control != null) {
            if (control.equals(test)) {
                XMLAssert.fail((String)("Expected test value NOT to be equal to control but both were " + test));
            }
        } else if (test != null) {
            XMLAssert.fail((String)("control xPath evaluated to empty node set, but test xPath evaluated to " + test));
        }
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, String inXMLString) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        Document document = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, document);
    }

    public static void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, Document inDocument) throws TransformerException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        XMLAssert.assertEquals((String)expectedValue, (String)simpleXpathEngine.evaluate(xpathExpression, inDocument));
    }

    public static void assertXpathExists(String xPathExpression, String inXMLString) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Document inDocument = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathExists(xPathExpression, inDocument);
    }

    public static void assertXpathExists(String xPathExpression, Document inDocument) throws TransformerException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        NodeList nodeList = simpleXpathEngine.getMatchingNodes(xPathExpression, inDocument);
        int matches = nodeList.getLength();
        XMLAssert.assertTrue((String)("Expecting to find matches for Xpath " + xPathExpression), (matches > 0 ? 1 : 0) != 0);
    }

    public static void assertXpathNotExists(String xPathExpression, String inXMLString) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Document inDocument = XMLUnit.buildControlDocument(inXMLString);
        XMLAssert.assertXpathNotExists(xPathExpression, inDocument);
    }

    public static void assertXpathNotExists(String xPathExpression, Document inDocument) throws TransformerException {
        SimpleXpathEngine simpleXpathEngine = new SimpleXpathEngine();
        NodeList nodeList = simpleXpathEngine.getMatchingNodes(xPathExpression, inDocument);
        int matches = nodeList.getLength();
        XMLAssert.assertEquals((String)("Should be zero matches for Xpath " + xPathExpression), (int)0, (int)matches);
    }

    public static void assertXMLValid(String xmlString) throws SAXException, ParserConfigurationException {
        XMLAssert.assertXMLValid(new Validator(new StringReader(xmlString)));
    }

    public static void assertXMLValid(String xmlString, String systemId) throws SAXException, ParserConfigurationException {
        XMLAssert.assertXMLValid(new Validator(new StringReader(xmlString), systemId));
    }

    public static void assertXMLValid(String xmlString, String systemId, String doctype) throws SAXException, ParserConfigurationException {
        XMLAssert.assertXMLValid(new Validator(new StringReader(xmlString), systemId, doctype));
    }

    public static void assertXMLValid(Validator validator) {
        XMLAssert.assertEquals((String)validator.toString(), (boolean)true, (boolean)validator.isValid());
    }

    public static void assertNodeTestPasses(String xmlString, NodeTester tester, short nodeType) throws SAXException, ParserConfigurationException, IOException {
        NodeTest test = new NodeTest(xmlString);
        XMLAssert.assertNodeTestPasses(test, tester, new short[]{nodeType}, true);
    }

    public static void assertNodeTestPasses(NodeTest test, NodeTester tester, short[] nodeTypes, boolean assertion) {
        block3: {
            try {
                test.performTest(tester, nodeTypes);
                if (!assertion) {
                    XMLAssert.fail((String)"Expected node test to fail, but it passed!");
                }
            }
            catch (NodeTestException e) {
                if (!assertion) break block3;
                XMLAssert.fail((String)("Expected node test to pass, but it failed! " + e.getMessage()));
            }
        }
    }
}

