/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.util.StringTokenizer;
import junit.framework.Test;
import org.jboss.test.AbstractTestSetup;
import org.jboss.test.JBossClusteredTestCase;
import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestClusteredServices;
import org.jboss.test.JBossTestServices;
import org.jboss.test.JBossTestSetup;

public class JBossTestClusteredSetup
extends JBossTestSetup {
    private String jarNames;

    public JBossTestClusteredSetup(Test test, String jarNames) throws Exception {
        super(JBossClusteredTestCase.class, test);
        this.jarNames = jarNames;
    }

    public JBossTestClusteredSetup(Test test) throws Exception {
        super(test);
    }

    public JBossTestServices createTestServices() {
        return new JBossTestClusteredServices(((Object)((Object)this)).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        if (this.jarNames == null) {
            return;
        }
        JBossTestCase.deploymentException = null;
        try {
            StringTokenizer st = new StringTokenizer(this.jarNames, ", ");
            while (st.hasMoreTokens()) {
                String jarName = st.nextToken();
                this.redeploy(jarName);
                this.getLog().debug((Object)("deployed package: " + jarName));
            }
        }
        catch (Exception ex) {
            JBossTestCase.deploymentException = ex;
        }
        JBossTestClusteredSetup jBossTestClusteredSetup = this;
        synchronized (jBossTestClusteredSetup) {
            ((Object)((Object)this)).wait(2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            if (this.jarNames != null) {
                int i;
                StringTokenizer st = new StringTokenizer(this.jarNames, ", ");
                String[] depoyments = new String[st.countTokens()];
                for (i = depoyments.length - 1; i >= 0; --i) {
                    depoyments[i] = st.nextToken();
                }
                for (i = 0; i < depoyments.length; ++i) {
                    String jarName = depoyments[i];
                    this.getLog().debug((Object)("Attempt undeploy of " + jarName));
                    this.undeploy(jarName);
                    this.getLog().debug((Object)("undeployed package: " + jarName));
                }
            }
            super.tearDown();
        }
        finally {
            AbstractTestSetup.delegate = null;
        }
    }
}

