/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache;

import java.io.File;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.FileNameUtility;
import org.rhq.plugins.jbosscache.CacheConfigurationHelper;
import org.rhq.plugins.jmx.JMXComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheSubsystemComponent<T extends JMXComponent<JBossASServerComponent>>
implements ResourceComponent<T>,
CreateChildResourceFacet {
    private final Log log = LogFactory.getLog(JBossCacheSubsystemComponent.class);
    ResourceContext<T> ctx;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void stop() {
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        JBossASServerComponent parentResourceComponent = (JBossASServerComponent)this.ctx.getParentResourceComponent();
        Configuration config = report.getResourceConfiguration();
        String name = report.getUserSpecifiedResourceName();
        File deployDir = new File(parentResourceComponent.getConfigurationPath() + "/deploy");
        File deploymentFile = new File(deployDir, FileNameUtility.formatFileName((String)name) + "-cache-service.xml");
        String flavour = config.getSimple("Flavour").getStringValue();
        boolean isTc = false;
        if (flavour != null && flavour.startsWith("tree")) {
            isTc = true;
        }
        String mbeanName = "jboss.cache:name=" + name;
        try {
            CacheConfigurationHelper helper = new CacheConfigurationHelper();
            helper.writeConfig(deploymentFile, config, mbeanName, false);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            report.setErrorMessage(ioe.getLocalizedMessage());
            report.setException((Throwable)ioe);
            report.setStatus(CreateResourceStatus.FAILURE);
            return report;
        }
        String objectName = mbeanName;
        objectName = isTc ? objectName + ",treecache-interceptor=CacheMgmtInterceptor" : objectName + ",cache-interceptor=CacheMgmtInterceptor";
        try {
            ObjectName on = new ObjectName(objectName);
            objectName = on.getCanonicalName();
            report.setResourceKey(objectName);
        }
        catch (MalformedObjectNameException e) {
            this.log.warn((Object)("Invalid key [" + objectName + "]: " + e.getMessage()));
            return report;
        }
        report.setResourceName(name);
        report.setStatus(CreateResourceStatus.SUCCESS);
        return report;
    }

    public EmsConnection getEmsConnection() {
        return ((JMXComponent)this.ctx.getParentResourceComponent()).getEmsConnection();
    }

    public void start(ResourceContext<T> context) throws Exception {
        this.ctx = context;
    }
}

