/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.ha.framework.interfaces;

import java.io.IOException;

import org.jboss.util.stream.IMarshalledValue;

/**
 * <code>IMarshalledValue</code> subinterface intended for implementations that
 * intend to hold onto a ref to deserialized form of the object they wrap.
 * 
 * @author Brian Stansberry
 */
public interface CachableMarshalledValue extends IMarshalledValue
{
   /**
    * Serialize any deserialized wrapped object to a byte[] and release any 
    * references to the deserialized form.
    * 
    * @return the serialized form of the wrapped object, or <code>null</code>
    *         if there was no wrapped object.
    *         
    * @throws IOException
    */
   byte[] toByteArray() throws IOException;
}
